<?php
namespace Mainto\Bridge\Invokes\HimoProductStoreV2\Order\Http;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method paperlessOrdersByParams(array|\Mainto\Bridge\Structs\HimoProductStoreV2\Order\Http\Cmd\PaperlessOrdersCmd $params)
 * @method listByParams(array|\Mainto\Bridge\Structs\HimoProductStoreV2\Order\Http\Cmd\ListCmd $params)
 * @method waitPayOrderDetailByParams(array|\Mainto\Bridge\Structs\HimoProductStoreV2\Order\Http\Cmd\DetailCmd $params)
 * @method detailByParams(array|\Mainto\Bridge\Structs\HimoProductStoreV2\Order\Http\Cmd\DetailCmd $params)
 * @method createByParams(array|\Mainto\Bridge\Structs\HimoProductStoreV2\Order\Http\Cmd\CreateCmd $params)
 * @method modifyByParams(array|\Mainto\Bridge\Structs\HimoProductStoreV2\Order\Http\Cmd\ModifyCmd $params)
 * @method changeReserveTimeByParams(array|\Mainto\Bridge\Structs\HimoProductStoreV2\Order\Http\Cmd\ChangeReserveTimeCmd $params)
 * @method getMembershipByParams(array|\Mainto\Bridge\Structs\HimoProductStoreV2\Order\Http\Cmd\DetailCmd $params)
 * @method setMembershipByParams(array|\Mainto\Bridge\Structs\HimoProductStoreV2\Order\Http\Cmd\OrderCmd\SetMembershipCmd $params)
 * @method cleanMembershipByParams(array|\Mainto\Bridge\Structs\HimoProductStoreV2\Order\Http\Cmd\OrderCmd\CleanMembershipCmd $params)
 * @method changeOrderDataByParams(array|\Mainto\Bridge\Structs\HimoProductStoreV2\Order\Http\Cmd\ChangeOrderDataCmd $params)
 */
class Order {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 无纸化订单列表
     *
     * @var  \Mainto\Bridge\Structs\HimoProductStoreV2\Order\Http\Cmd\PaperlessOrdersCmd $cmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\HimoProductStoreV2\Order\Http\DTO\Lists\PaperlessOrderList\PaperlessOrderListDTO
     */
    public static function paperlessOrders (\Mainto\Bridge\Structs\HimoProductStoreV2\Order\Http\Cmd\PaperlessOrdersCmd $cmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->paperlessOrders($cmd),
            "\Mainto\Bridge\Structs\HimoProductStoreV2\Order\Http\DTO\Lists\PaperlessOrderList\PaperlessOrderListDTO"
        );
    }


    /**
     * 订单列表
     *
     * @var  \Mainto\Bridge\Structs\HimoProductStoreV2\Order\Http\Cmd\ListCmd $cmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\HimoProductStoreV2\Order\Http\DTO\Lists\OrderList\ListDTO
     */
    public static function list (\Mainto\Bridge\Structs\HimoProductStoreV2\Order\Http\Cmd\ListCmd $cmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->list($cmd),
            "\Mainto\Bridge\Structs\HimoProductStoreV2\Order\Http\DTO\Lists\OrderList\ListDTO"
        );
    }


    /**
     * 待支付订单详情
     *
     * @var  \Mainto\Bridge\Structs\HimoProductStoreV2\Order\Http\Cmd\DetailCmd $cmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\HimoProductStoreV2\Order\Http\DTO\WaitPayOrderDetailDTO
     */
    public static function waitPayOrderDetail (\Mainto\Bridge\Structs\HimoProductStoreV2\Order\Http\Cmd\DetailCmd $cmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->waitPayOrderDetail($cmd),
            "\Mainto\Bridge\Structs\HimoProductStoreV2\Order\Http\DTO\WaitPayOrderDetailDTO"
        );
    }


    /**
     * 订单详情
     *
     * @var  \Mainto\Bridge\Structs\HimoProductStoreV2\Order\Http\Cmd\DetailCmd $cmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\HimoProductStoreV2\Order\Http\DTO\DetailDTO
     */
    public static function detail (\Mainto\Bridge\Structs\HimoProductStoreV2\Order\Http\Cmd\DetailCmd $cmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->detail($cmd),
            "\Mainto\Bridge\Structs\HimoProductStoreV2\Order\Http\DTO\DetailDTO"
        );
    }


    /**
     * 创建订单
     *
     * @var  \Mainto\Bridge\Structs\HimoProductStoreV2\Order\Http\Cmd\CreateCmd $cmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\HimoProductStoreV2\Order\Http\DTO\OrderDiffDTO
     */
    public static function create (\Mainto\Bridge\Structs\HimoProductStoreV2\Order\Http\Cmd\CreateCmd $cmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->create($cmd),
            "\Mainto\Bridge\Structs\HimoProductStoreV2\Order\Http\DTO\OrderDiffDTO"
        );
    }


    /**
     * 修改订单
     *
     * @var  \Mainto\Bridge\Structs\HimoProductStoreV2\Order\Http\Cmd\ModifyCmd $cmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\HimoProductStoreV2\Order\Http\DTO\OrderDiffDTO
     */
    public static function modify (\Mainto\Bridge\Structs\HimoProductStoreV2\Order\Http\Cmd\ModifyCmd $cmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->modify($cmd),
            "\Mainto\Bridge\Structs\HimoProductStoreV2\Order\Http\DTO\OrderDiffDTO"
        );
    }


    /**
     * 修改预约时间
     *
     * @var  \Mainto\Bridge\Structs\HimoProductStoreV2\Order\Http\Cmd\ChangeReserveTimeCmd $cmd
     * @throws  \Exception
     * @return  bool
     */
    public static function changeReserveTime (\Mainto\Bridge\Structs\HimoProductStoreV2\Order\Http\Cmd\ChangeReserveTimeCmd $cmd) {
        return self::getClass()->changeReserveTime($cmd);
    }


    /**
     * 获取学生会员标签
     *
     * @var  \Mainto\Bridge\Structs\HimoProductStoreV2\Order\Http\Cmd\DetailCmd $cmd
     * @throws  \Exception
     * @return  string
     */
    public static function getMembership (\Mainto\Bridge\Structs\HimoProductStoreV2\Order\Http\Cmd\DetailCmd $cmd) {
        return self::getClass()->getMembership($cmd);
    }


    /**
     * 设置学生会员资格
     *
     * @var  \Mainto\Bridge\Structs\HimoProductStoreV2\Order\Http\Cmd\OrderCmd\SetMembershipCmd $cmd
     * @throws  \Exception
     * @return  bool
     */
    public static function setMembership (\Mainto\Bridge\Structs\HimoProductStoreV2\Order\Http\Cmd\OrderCmd\SetMembershipCmd $cmd) {
        return self::getClass()->setMembership($cmd);
    }


    /**
     * 清除学生会员资格
     *
     * @var  \Mainto\Bridge\Structs\HimoProductStoreV2\Order\Http\Cmd\OrderCmd\CleanMembershipCmd $cmd
     * @throws  \Exception
     * @return  bool
     */
    public static function cleanMembership (\Mainto\Bridge\Structs\HimoProductStoreV2\Order\Http\Cmd\OrderCmd\CleanMembershipCmd $cmd) {
        return self::getClass()->cleanMembership($cmd);
    }


    /**
     * 修改订单属性
     *
     * @var  \Mainto\Bridge\Structs\HimoProductStoreV2\Order\Http\Cmd\ChangeOrderDataCmd $cmd
     * @throws  \Exception
     * @return  bool
     */
    public static function changeOrderData (\Mainto\Bridge\Structs\HimoProductStoreV2\Order\Http\Cmd\ChangeOrderDataCmd $cmd) {
        return self::getClass()->changeOrderData($cmd);
    }


    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProductStoreV2', 'Order\Http\Order');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProductStoreV2', 'Order\Http\Order');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}