<?php
namespace Mainto\Bridge\Invokes\HimoProductStoreV2\Order\Http;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getStoreProductTreeByParams(array|\Mainto\Bridge\Structs\HimoProductStoreV2\Order\Http\Cmd\ProductCmd\StoreProductTreeCmd $params)
 * @method detailByParams(array|\Mainto\Bridge\Structs\HimoProductStoreV2\Order\Http\Cmd\ProductCmd\ProductDetailCmd $params)
 */
class Product {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取门店产品tree
     *
     * @var  \Mainto\Bridge\Structs\HimoProductStoreV2\Order\Http\Cmd\ProductCmd\StoreProductTreeCmd $cmd
     * @throws  \Exception
     * @return  array
     */
    public static function getStoreProductTree (\Mainto\Bridge\Structs\HimoProductStoreV2\Order\Http\Cmd\ProductCmd\StoreProductTreeCmd $cmd) {
        return self::getClass()->getStoreProductTree($cmd);
    }


    /**
     * 产品详情
     *
     * @var  \Mainto\Bridge\Structs\HimoProductStoreV2\Order\Http\Cmd\ProductCmd\ProductDetailCmd $cmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\HimoProductStoreV2\Order\Http\DTO\Product\ProductDTO
     */
    public static function detail (\Mainto\Bridge\Structs\HimoProductStoreV2\Order\Http\Cmd\ProductCmd\ProductDetailCmd $cmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->detail($cmd),
            "\Mainto\Bridge\Structs\HimoProductStoreV2\Order\Http\DTO\Product\ProductDTO"
        );
    }


    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProductStoreV2', 'Order\Http\Product');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProductStoreV2', 'Order\Http\Product');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}