<?php
namespace Mainto\Bridge\Invokes\HimoProductStoreV2\User\Http;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method detailByParams(array|\Mainto\Bridge\Structs\HimoProductStoreV2\User\Http\Cmd\UserDetailCmd $params)
 */
class User {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 用户信息
     *
     * @var  \Mainto\Bridge\Structs\HimoProductStoreV2\User\Http\Cmd\UserDetailCmd $cmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\HimoProductStoreV2\User\Http\DTO\UserDTO
     */
    public static function detail (\Mainto\Bridge\Structs\HimoProductStoreV2\User\Http\Cmd\UserDetailCmd $cmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->detail($cmd),
            "\Mainto\Bridge\Structs\HimoProductStoreV2\User\Http\DTO\UserDTO"
        );
    }


    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProductStoreV2', 'User\Http\User');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProductStoreV2', 'User\Http\User');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}