<?php
namespace Mainto\Bridge\Invokes\HimoProductStoreV2\Product\Http;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method listPackageByParams(array $params)
 * @method getSubPackageByParams(array|\Mainto\Bridge\Structs\HimoProductStoreV2\Product\Http\Cmd\PackageCmd\SubPackageDetailCmd $params)
 */
class Package {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取套餐列表
     *
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\HimoProductStoreV2\Product\Http\DTO\Package\PackageDTO[]
     */
    public static function listPackage () {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->listPackage(),
            "\Mainto\Bridge\Structs\HimoProductStoreV2\Product\Http\DTO\Package\PackageDTO[]"
        );
    }

    /**
     * 获取子套餐信息
     *
     * @var  \Mainto\Bridge\Structs\HimoProductStoreV2\Product\Http\Cmd\PackageCmd\SubPackageDetailCmd $cmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\HimoProductStoreV2\Product\Http\DTO\Package\SubPackageDTO
     */
    public static function getSubPackage (\Mainto\Bridge\Structs\HimoProductStoreV2\Product\Http\Cmd\PackageCmd\SubPackageDetailCmd $cmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getSubPackage($cmd),
            "\Mainto\Bridge\Structs\HimoProductStoreV2\Product\Http\DTO\Package\SubPackageDTO"
        );
    }


    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProductStoreV2', 'Product\Http\Package');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProductStoreV2', 'Product\Http\Package');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}