<?php
namespace Mainto\Bridge\Invokes\HimoProductStoreV2\Order\Http;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method cancelByParams(array|\Mainto\Bridge\Structs\HimoProductStoreV2\Order\Http\Cmd\RetakeCmd\CancelCmd $params)
 */
class Retake {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 取消未支付重拍订单
     *
     * @var  \Mainto\Bridge\Structs\HimoProductStoreV2\Order\Http\Cmd\RetakeCmd\CancelCmd $cmd
     * @throws  \Exception
     * @return  bool
     */
    public static function cancel (\Mainto\Bridge\Structs\HimoProductStoreV2\Order\Http\Cmd\RetakeCmd\CancelCmd $cmd) {
        return self::getClass()->cancel($cmd);
    }


    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProductStoreV2', 'Order\Http\Retake');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProductStoreV2', 'Order\Http\Retake');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}