<?php
namespace Mainto\Bridge\Invokes\HimoProductStoreV2\WebSocket\Http;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getManageRoomSignatureByParams(array $params)
 * @method enterManageRoomByParams(array $params)
 * @method relayManageMessageByParams(array|\Mainto\Bridge\Structs\HimoProductStoreV2\WebSocket\Http\Cmd\ReplyMessageCmd $params)
 * @method getDingRoomSignatureByParams(array $params)
 * @method enterDingRoomByParams(array $params)
 * @method relayDingMessageByParams(array|\Mainto\Bridge\Structs\HimoProductStoreV2\WebSocket\Http\Cmd\ReplyMessageCmd $params)
 */
class WebSocket {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 管理端获取ws签名
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getManageRoomSignature () {
        return self::getClass()->getManageRoomSignature();
    }

    /**
     * 管理端加入ws房间
     *
     * @throws  \Exception
     * @return  bool
     */
    public static function enterManageRoom () {
        return self::getClass()->enterManageRoom();
    }

    /**
     * 管理端加入ws房间
     *
     * @var  \Mainto\Bridge\Structs\HimoProductStoreV2\WebSocket\Http\Cmd\ReplyMessageCmd $cmd
     * @throws  \Exception
     * @return  bool
     */
    public static function relayManageMessage (\Mainto\Bridge\Structs\HimoProductStoreV2\WebSocket\Http\Cmd\ReplyMessageCmd $cmd) {
        return self::getClass()->relayManageMessage($cmd);
    }


    /**
     * 钉钉端获取ws签名
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getDingRoomSignature () {
        return self::getClass()->getDingRoomSignature();
    }

    /**
     * 钉钉端加入ws房间
     *
     * @throws  \Exception
     * @return  bool
     */
    public static function enterDingRoom () {
        return self::getClass()->enterDingRoom();
    }

    /**
     * 管理端加入ws房间
     *
     * @var  \Mainto\Bridge\Structs\HimoProductStoreV2\WebSocket\Http\Cmd\ReplyMessageCmd $cmd
     * @throws  \Exception
     * @return  bool
     */
    public static function relayDingMessage (\Mainto\Bridge\Structs\HimoProductStoreV2\WebSocket\Http\Cmd\ReplyMessageCmd $cmd) {
        return self::getClass()->relayDingMessage($cmd);
    }


    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProductStoreV2', 'WebSocket\Http\WebSocket');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProductStoreV2', 'WebSocket\Http\WebSocket');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}