<?php
namespace Mainto\Bridge\Invokes\HimoPhoto;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method hookCreatedStreamInitPhotoByParams(array $params)
 * @method hookKpsEvaByParams(array $params)
 * @method hookRetoucherBindByParams(array $params)
 * @method hookWorkloadByParams(array $params)
 * @method createKpFinishByParams(array $params)
 * @method hookSyncFinishPhotoByParams(array $params)
 */
class Hook {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 监听云端创建流水
     *
     * @param  array $stream 流水信息 [ require true ]
     * @param  array $photos 照片 [ require true ]
     * @param  array $extends 扩展信息 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function hookCreatedStreamInitPhoto (array $stream, array $extends, array $photos) {
        return self::getClass()->hookCreatedStreamInitPhoto([
            "stream" => $stream,
            "extends" => $extends,
            "photos" => $photos,
        ]);
    }

    /**
     * 监听看片评价
     *
     * @param  string $stream_num 流水号 [ require true ]
     * @param  mixed $store_evaluate_stream 看片师评价 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function hookKpsEva (string $stream_num, $store_evaluate_stream) {
        return self::getClass()->hookKpsEva([
            "stream_num" => $stream_num,
            "store_evaluate_stream" => $store_evaluate_stream,
        ]);
    }

    /**
     * 监听修图师接单
     *
     * @support  string $stream_num 流水号 [ require true ]
     * @support  int $retoucher_id 修图师id [ require false ]
     * @support  int $retoucher_org_id 修图师id [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function hookRetoucherBind () {
        return self::getClass()->hookRetoucherBind([
        ]);
    }

    /**
     * 监听工作量
     *
     * @param  array $stream_nums 流水ids [ require true ]
     * @param  int $staff_id 化妆师Id [ require true ]
     * @param  string $pool_type 池子类型 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function hookWorkload (array $stream_nums, int $staff_id, string $pool_type) {
        return self::getClass()->hookWorkload([
            "stream_nums" => $stream_nums,
            "staff_id" => $staff_id,
            "pool_type" => $pool_type,
        ]);
    }

    /**
     * 监听看片完成
     *
     * @param  string $orderNum 订单号 [ require true ]
     * @param  string $type 看片类型 [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function createKpFinish (string $orderNum, string $type = '') {
        return self::getClass()->createKpFinish([
            "orderNum" => $orderNum,
            "type" => $type,
        ]);
    }

    /**
     * 同步最终成片
     *
     * @param  array $photos 最终成片 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function hookSyncFinishPhoto (array $photos) {
        return self::getClass()->hookSyncFinishPhoto([
            "photos" => $photos,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoPhoto', 'Hook');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoPhoto', 'Hook');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}