<?php
namespace Mainto\Bridge\Invokes\HimoPhoto;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method searchByParams(array $params)
 * @method detailByCloudPhotoIdByParams(array $params)
 */
class Photo {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 搜素
     *
     * @param  mixed $cond 筛选 [ require true ]
     * @support  array $fields 获取域 [ require false ]
     * @param  int $page 页码 [ require false ]
     * @param  int $pageSize 条数 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function search ($cond, int $page = 1, int $pageSize = 10) {
        return self::getClass()->search([
            "cond" => $cond,
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 详情byCloudPhotoId
     *
     * @param  int $cloudPhotoId 云端照片id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function detailByCloudPhotoId (int $cloudPhotoId) {
        return self::getClass()->detailByCloudPhotoId([
            "cloudPhotoId" => $cloudPhotoId,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoPhoto', 'Photo');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoPhoto', 'Photo');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}