<?php
namespace Mainto\Bridge\Invokes\HimoPhoto;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method tagAttitudeByParams(array $params)
 * @method unTagAttitudeByParams(array $params)
 */
class Evaluate {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 标记态度
     *
     * @param  int $photoId 照片id [ require true ]
     * @param  int $staffId staffId [ require true ]
     * @param  string $operationType 员工类型 [ require true ]
     * @param  string $attitude 态度 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function tagAttitude (int $photoId, int $staffId, string $operationType, string $attitude) {
        return self::getClass()->tagAttitude([
            "photoId" => $photoId,
            "staffId" => $staffId,
            "operationType" => $operationType,
            "attitude" => $attitude,
        ]);
    }

    /**
     * 取消标记态度
     *
     * @param  int $photoId 照片id [ require true ]
     * @param  int $staffId staffId [ require true ]
     * @param  string $operationType 员工类型 [ require true ]
     * @param  string $attitude 态度 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function unTagAttitude (int $photoId, int $staffId, string $operationType, string $attitude) {
        return self::getClass()->unTagAttitude([
            "photoId" => $photoId,
            "staffId" => $staffId,
            "operationType" => $operationType,
            "attitude" => $attitude,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoPhoto', 'Evaluate');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoPhoto', 'Evaluate');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}