<?php
namespace Mainto\Bridge\Invokes\HimoPhoto;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method hookCreatedStreamInitPhotoByParams(array $params)
 * @method hookKpsEvaByParams(array $params)
 * @method hookRetoucherBindByParams(array $params)
 * @method hookWorkloadByParams(array $params)
 * @method createKpFinishByParams(array $params)
 */
class Hook {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 监听云端创建流水
     *
     * @param  array $stream 流水信息 [ require true ]
     * @param  array $photos 照片 [ require true ]
     * @param  array $extends 扩展信息 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function hookCreatedStreamInitPhoto (array $stream, array $extends, array $photos) {
        return self::getClass()->hookCreatedStreamInitPhoto([
            "stream" => $stream,
            "extends" => $extends,
            "photos" => $photos,
        ]);
    }

    /**
     * 监听看片评价
     *
     * @throws  \Exception
     * @return  bool
     */
    public static function hookKpsEva () {
        return self::getClass()->hookKpsEva();
    }

    /**
     * 监听修图师接单
     *
     * @throws  \Exception
     * @return  bool
     */
    public static function hookRetoucherBind () {
        return self::getClass()->hookRetoucherBind();
    }

    /**
     * 监听工作量
     *
     * @throws  \Exception
     * @return  bool
     */
    public static function hookWorkload () {
        return self::getClass()->hookWorkload();
    }

    /**
     * 监听看片完成
     *
     * @throws  \Exception
     * @return  bool
     */
    public static function createKpFinish () {
        return self::getClass()->createKpFinish();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoPhoto', 'Hook');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoPhoto', 'Hook');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}