<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-04-01 17:19:27
 */
namespace Mainto\Bridge\Invokes\HimoMicroNotify\Notify;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Announcement
 * @method announcementListByParams(array $params) 获取公告列表
 * @method announcementListWithPageByParams(array $params) 获取公告列表(分页)
 * @method createAnnouncementByParams(array $params) 创建公告
 * @method editAnnouncementByParams(array $params) 编辑公告
 * @method announcementDetailByParams(array $params) 公告详情
 * @method announcementPublisherByParams(array $params) 获取发布人
 * @method abolishByParams(array $params) 作废公告
 * @method exportReadReportByParams(array $params) 导出公告阅读报告
 * @method getPopsByParams(array $params) 获取指定日期的弹窗
 * @method getReadMessagesByParams(array $params) 获取已读消息列表
 * @method getUnreadAnnouncementByParams(array $params) 获取未读消息列表
 * @method readAnnouncementByParams(array $params) 读公告
 * @method topByParams(array $params) 置顶
 * @method batchTopByParams(array $params) 批量更新公告置顶状态
 * @method sendUnreadMessageByParams(array $params) 发送未读消息
 * @method createAnnouncementCategoryByParams(array $params) 创建公告板块
 * @method editAnnouncementCategoryByParams(array $params) 编辑公告板块
 * @method deleteAnnouncementCategoryByParams(array $params) 删除公告板块
 * @method getAnnouncementCategoryByParams(array $params) 获取公告板块
 * @method delaySendSingleMessageByParams(array $params) 接收MQ消息延迟推送通知
 */
class Announcement {
    private static string $serviceName = "HimoMicroNotify";

    private static string $className = "Notify\\Announcement";

    /**
     * 获取公告列表
     * @return  array
    */
    public static function announcementList (?\Mainto\Bridge\Structs\HimoMicroNotify\Notify\Cmd\Announcement\AnnouncementSearchCmd $announcementSearchCmd = null) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->announcementList($announcementSearchCmd),
            "\Mainto\Bridge\Structs\HimoMicroNotify\Notify\DTO\AnnouncementDTO\AnnouncementDTO[]"
        );
    }
    /**
     * 获取公告列表(分页)
     * @return  \Mainto\Bridge\Structs\HimoMicroNotify\Notify\DTO\AnnouncementDTO\AnnouncementListWithPageDTO
    */
    public static function announcementListWithPage (?\Mainto\Bridge\Structs\HimoMicroNotify\Notify\Cmd\Announcement\AnnouncementSearchCmd $announcementSearchCmd = null) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->announcementListWithPage($announcementSearchCmd),
            "\Mainto\Bridge\Structs\HimoMicroNotify\Notify\DTO\AnnouncementDTO\AnnouncementListWithPageDTO"
        );
    }
    /**
     * 创建公告
     * @return  \Mainto\Bridge\Structs\HimoMicroNotify\Notify\DTO\AnnouncementDTO\AnnouncementDTO
    */
    public static function createAnnouncement (\Mainto\Bridge\Structs\HimoMicroNotify\Notify\Cmd\Announcement\AnnouncementCreateCmd $announcementCreateCmd) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->createAnnouncement($announcementCreateCmd),
            "\Mainto\Bridge\Structs\HimoMicroNotify\Notify\DTO\AnnouncementDTO\AnnouncementDTO"
        );
    }
    /**
     * 编辑公告
     * @return  \Mainto\Bridge\Structs\HimoMicroNotify\Notify\DTO\AnnouncementDTO\AnnouncementDTO
    */
    public static function editAnnouncement (\Mainto\Bridge\Structs\HimoMicroNotify\Notify\Cmd\Announcement\AnnouncementEditCmd $announcementEditCmd) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->editAnnouncement($announcementEditCmd),
            "\Mainto\Bridge\Structs\HimoMicroNotify\Notify\DTO\AnnouncementDTO\AnnouncementDTO"
        );
    }
    /**
     * 公告详情
     * @return  \Mainto\Bridge\Structs\HimoMicroNotify\Notify\DTO\AnnouncementDTO\AnnouncementDTO
    */
    public static function announcementDetail (int $id) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->announcementDetail(["id" => $id]),
            "\Mainto\Bridge\Structs\HimoMicroNotify\Notify\DTO\AnnouncementDTO\AnnouncementDTO"
        );
    }
    /**
     * 获取发布人
     * @return  array
    */
    public static function announcementPublisher () {
        return RpcClass::getClass(self::$serviceName, self::$className)->announcementPublisher();
    }
    /**
     * 作废公告
     * @return  bool
    */
    public static function abolish (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->abolish(["id" => $id]);
    }
    /**
     * 导出公告阅读报告
     * @return  array
    */
    public static function exportReadReport (array $messageIds) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->exportReadReport(["messageIds" => $messageIds]),
            "\Mainto\Bridge\Structs\HimoMicroNotify\Notify\DTO\AnnouncementDTO\ReadRecordDTO[]"
        );
    }
    /**
     * 获取指定日期的弹窗
     * @return  array
    */
    public static function getPops (string $date) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getPops(["date" => $date]),
            "\Mainto\Bridge\Structs\HimoMicroNotify\Notify\DTO\AnnouncementDTO\AnnouncementDTO[]"
        );
    }
    /**
     * 获取已读消息列表
     * @return  array
    */
    public static function getReadMessages (int $reader) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getReadMessages(["reader" => $reader]);
    }
    /**
     * 获取未读消息列表
     * @return  array
    */
    public static function getUnreadAnnouncement (int $reader) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getUnreadAnnouncement(["reader" => $reader]);
    }
    /**
     * 读公告
     * @return  bool
    */
    public static function readAnnouncement (int $reader, int $messageId, string $readerType) {
        return RpcClass::getClass(self::$serviceName, self::$className)->readAnnouncement(["reader" => $reader, "messageId" => $messageId, "readerType" => $readerType]);
    }
    /**
     * 置顶
     * @return  mixed
    */
    public static function top (int $id, array $modules) {
        return RpcClass::getClass(self::$serviceName, self::$className)->top(["id" => $id, "modules" => $modules]);
    }
    /**
     * 批量更新公告置顶状态
     * @return  bool
    */
    public static function batchTop (array $ids, int $status) {
        return RpcClass::getClass(self::$serviceName, self::$className)->batchTop(["ids" => $ids, "status" => $status]);
    }
    /**
     * 发送未读消息
     * @return  bool
    */
    public static function sendUnreadMessage (string $messageId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->sendUnreadMessage(["messageId" => $messageId]);
    }
    /**
     * 创建公告板块
     * @return  bool
    */
    public static function createAnnouncementCategory (string $name) {
        return RpcClass::getClass(self::$serviceName, self::$className)->createAnnouncementCategory(["name" => $name]);
    }
    /**
     * 编辑公告板块
     * @return  bool
    */
    public static function editAnnouncementCategory (\Mainto\Bridge\Structs\HimoMicroNotify\Notify\Cmd\Announcement\AnnouncementCategoryEditCmd $announcementCategoryEditCmd) {
        return RpcClass::getClass(self::$serviceName, self::$className)->editAnnouncementCategory($announcementCategoryEditCmd);
    }
    /**
     * 删除公告板块
     * @return  bool
    */
    public static function deleteAnnouncementCategory (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->deleteAnnouncementCategory(["id" => $id]);
    }
    /**
     * 获取公告板块
     * @return  array
    */
    public static function getAnnouncementCategory () {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getAnnouncementCategory(),
            "\Mainto\Bridge\Structs\HimoMicroNotify\Notify\DTO\AnnouncementDTO\AnnouncementCategoryDTO[]"
        );
    }
    /**
     * 接收MQ消息延迟推送通知
     * @return  mixed
    */
    public static function delaySendSingleMessage (string $messageId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->delaySendSingleMessage(["messageId" => $messageId]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}