<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2022-06-13 11:58:11
 */
namespace Mainto\Bridge\Structs\HimoMicroNotify\Notify\Cmd\Announcement;

class AnnouncementEditCmd {
    /**
     * @var  int
     * message主键
     * validation: 
     */
    public int $id;
    /**
     * @var  string
     * 公告标题
     * validation: max:50
     */
    public string $title;
    /**
     * @var  null|string
     * 发布时间
     * validation: date_format:Y-m-d H:i:s|after:now
     */
    public ?string $publishAt = null;
    /**
     * @var  int
     * 发布人工号
     * validation: 
     */
    public int $publisher;
    /**
     * @var  int
     * 板块id
     * validation: 
     */
    public int $categoryId;
    /**
     * @var  null|string
     * 弹窗时间
     * validation: date_format:Y-m-d H:i:s|after:now
     */
    public ?string $popTime = null;
    /**
     * @var  int
     * 阅读时长/3-15s
     * validation: integer|between:3,15
     */
    public int $timeLimit = 3;
    /**
     * @var  array
     * 公告品牌列表
     * validation: moduleList
     */
    public array $modules;
    /**
     * @var  array
     * 可收到消息的门店列表
     * validation: 
     */
    public array $stores = [];
    /**
     * @var  array
     * 可收到消息的角色列表
     * validation: 
     */
    public array $roles = [];
    /**
     * @var  array
     * 附件列表
     * validation: attachmentsCount:10
     */
    public array $attachments = [];
    /**
     * @var  string
     * 配置名, 用于获取特定token等, xiaobai
     * validation: 
     */
    public string $config;
    /**
     * @var  bool
     * 
     * validation: 
     */
    public bool $top = false;
    /**
     * @var  string
     * 文本
     * validation: 
     */
    public string $content;
    /**
     * @var  string
     * 跳转链接
     * validation: 
     */
    public string $url;

    public function __construct (int $id, string $title, int $publisher, int $categoryId, array $modules, string $config, string $content, string $url) {
        $this->id = $id;
        $this->title = $title;
        $this->publisher = $publisher;
        $this->categoryId = $categoryId;
        $this->modules = $modules;
        $this->config = $config;
        $this->content = $content;
        $this->url = $url;
    }

    public static function create(int $id, string $title, int $publisher, int $categoryId, array $modules, string $config, string $content, string $url): self {
        return new self($id, $title, $publisher, $categoryId, $modules, $config, $content, $url);
    }

    public function setId(int $id): self {
        $this->id = $id;

        return $this;
    }

    public function setTitle(string $title): self {
        $this->title = $title;

        return $this;
    }

    public function setPublishAt(?string $publishAt): self {
        $this->publishAt = $publishAt;

        return $this;
    }

    public function setPublisher(int $publisher): self {
        $this->publisher = $publisher;

        return $this;
    }

    public function setCategoryId(int $categoryId): self {
        $this->categoryId = $categoryId;

        return $this;
    }

    public function setPopTime(?string $popTime): self {
        $this->popTime = $popTime;

        return $this;
    }

    public function setTimeLimit(int $timeLimit): self {
        $this->timeLimit = $timeLimit;

        return $this;
    }

    public function setModules(array $modules): self {
        $this->modules = $modules;

        return $this;
    }

    public function setStores(array $stores): self {
        $this->stores = $stores;

        return $this;
    }

    public function setRoles(array $roles): self {
        $this->roles = $roles;

        return $this;
    }

    public function setAttachments(array $attachments): self {
        $this->attachments = $attachments;

        return $this;
    }

    public function setConfig(string $config): self {
        $this->config = $config;

        return $this;
    }

    public function setTop(bool $top): self {
        $this->top = $top;

        return $this;
    }

    public function setContent(string $content): self {
        $this->content = $content;

        return $this;
    }

    public function setUrl(string $url): self {
        $this->url = $url;

        return $this;
    }
}