<?php
namespace Mainto\Bridge\Invokes\HimoMicroNotify\Notify;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method bytedanceMicroAppPushByParams(array|\Mainto\Bridge\Structs\HimoMicroNotify\Notify\Cmd\SubscribeMessage\BytedanceSubscribeMessagePushCmd $params)
 */
class SubscribeMessage {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 字节小程序订阅消息推送
     *
     * @var  \Mainto\Bridge\Structs\HimoMicroNotify\Notify\Cmd\SubscribeMessage\BytedanceSubscribeMessagePushCmd $cmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\HimoMicroNotify\Notify\DTO\SubscribeMessageDTO\BytedanceSubscribeMessageDTO
     */
    public static function bytedanceMicroAppPush (\Mainto\Bridge\Structs\HimoMicroNotify\Notify\Cmd\SubscribeMessage\BytedanceSubscribeMessagePushCmd $cmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->bytedanceMicroAppPush($cmd),
            "\Mainto\Bridge\Structs\HimoMicroNotify\Notify\DTO\SubscribeMessageDTO\BytedanceSubscribeMessageDTO"
        );
    }


    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoMicroNotify', 'Notify\SubscribeMessage');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoMicroNotify', 'Notify\SubscribeMessage');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}