<?php
namespace Mainto\Bridge\Invokes\HimoMicroNotify\Notify;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method callbackByParams(array|\Mainto\Bridge\Structs\HimoMicroNotify\Notify\Cmd\CallbackCmd $params)
 * @method hookByParams(array $params)
 * @method sendInteractiveCardByParams(array|\Mainto\Bridge\Structs\HimoMicroNotify\Notify\Cmd\SendInteractiveCardCmd $params)
 * @method sendInteractiveCardAsyncByParams(array|\Mainto\Bridge\Structs\HimoMicroNotify\Notify\Cmd\SendInteractiveCardCmd $params)
 * @method updateInteractiveCardCmdByParams(array|\Mainto\Bridge\Structs\HimoMicroNotify\Notify\Cmd\UpdateInteractiveCardCmd $params)
 * @method getInteractiveCardMessageByParams(array $params)
 * @method refreshAccessTokenByParams(array $params)
 */
class Dingtalk {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 钉钉通用事件回调(服务可用验证)
     *
     * @var  \Mainto\Bridge\Structs\HimoMicroNotify\Notify\Cmd\CallbackCmd $cmd
     * @throws  \Exception
     * @return  string
     */
    public static function callback (\Mainto\Bridge\Structs\HimoMicroNotify\Notify\Cmd\CallbackCmd $cmd) {
        return self::getClass()->callback($cmd);
    }


    /**
     * 钉钉消息回调(互动卡片)
     *
     * @throws  \Exception
     * @return  string
     */
    public static function hook () {
        return self::getClass()->hook();
    }

    /**
     *  (使用 http api 时需要 header 要带上 open-token)
     *
     * @var  \Mainto\Bridge\Structs\HimoMicroNotify\Notify\Cmd\SendInteractiveCardCmd $cmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\HimoMicroNotify\Notify\DTO\InteractiveCardMessageDTO
     */
    public static function sendInteractiveCard (\Mainto\Bridge\Structs\HimoMicroNotify\Notify\Cmd\SendInteractiveCardCmd $cmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->sendInteractiveCard($cmd),
            "\Mainto\Bridge\Structs\HimoMicroNotify\Notify\DTO\InteractiveCardMessageDTO"
        );
    }


    /**
     *  (使用 http api 时需要 header 要带上 open-token)
     *
     * @var  \Mainto\Bridge\Structs\HimoMicroNotify\Notify\Cmd\SendInteractiveCardCmd $cmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\HimoMicroNotify\Notify\DTO\InteractiveCardMessageDTO
     */
    public static function sendInteractiveCardAsync (\Mainto\Bridge\Structs\HimoMicroNotify\Notify\Cmd\SendInteractiveCardCmd $cmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->sendInteractiveCardAsync($cmd),
            "\Mainto\Bridge\Structs\HimoMicroNotify\Notify\DTO\InteractiveCardMessageDTO"
        );
    }


    /**
     * 修改要将原内容都传过来(原内容可以通过 getInteractiveCardMessage 获取) (使用 http api 时需要 header 要带上 open-token)
     *
     * @var  \Mainto\Bridge\Structs\HimoMicroNotify\Notify\Cmd\UpdateInteractiveCardCmd $cmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\HimoMicroNotify\Notify\DTO\InteractiveCardMessageDTO
     */
    public static function updateInteractiveCardCmd (\Mainto\Bridge\Structs\HimoMicroNotify\Notify\Cmd\UpdateInteractiveCardCmd $cmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->updateInteractiveCardCmd($cmd),
            "\Mainto\Bridge\Structs\HimoMicroNotify\Notify\DTO\InteractiveCardMessageDTO"
        );
    }


    /**
     *  (使用 http api 时需要 header 要带上 open-token)
     *
     * @param  string $messageId messageId [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\HimoMicroNotify\Notify\DTO\InteractiveCardMessageDTO
     */
    public static function getInteractiveCardMessage (string $messageId) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getInteractiveCardMessage([
                            "messageId" => $messageId,
                        ]),
            "\Mainto\Bridge\Structs\HimoMicroNotify\Notify\DTO\InteractiveCardMessageDTO"
        );
    }

    /**
     * refreshAccessToken
     *
     * @param  string $config config [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function refreshAccessToken (string $config) {
        return self::getClass()->refreshAccessToken([
            "config" => $config,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoMicroNotify', 'Notify\Dingtalk');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoMicroNotify', 'Notify\Dingtalk');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}