<?php
namespace Mainto\Bridge\Invokes\HimoMicroNotify\Notify;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method announcementListByParams(array|\Mainto\Bridge\Structs\HimoMicroNotify\Notify\Cmd\Announcement\AnnouncementSearchCmd $params)
 * @method announcementListWithPageByParams(array|\Mainto\Bridge\Structs\HimoMicroNotify\Notify\Cmd\Announcement\AnnouncementSearchCmd $params)
 * @method createAnnouncementByParams(array|\Mainto\Bridge\Structs\HimoMicroNotify\Notify\Cmd\Announcement\AnnouncementCreateCmd $params)
 * @method editAnnouncementByParams(array|\Mainto\Bridge\Structs\HimoMicroNotify\Notify\Cmd\Announcement\AnnouncementEditCmd $params)
 * @method announcementDetailByParams(array $params)
 * @method abolishByParams(array $params)
 * @method exportReadReportByParams(array $params)
 * @method getPopsByParams(array $params)
 * @method getReadMessagesByParams(array $params)
 * @method readAnnouncementByParams(array $params)
 * @method topByParams(array $params)
 * @method createAnnouncementCategoryByParams(array $params)
 * @method editAnnouncementCategoryByParams(array|\Mainto\Bridge\Structs\HimoMicroNotify\Notify\Cmd\Announcement\AnnouncementCategoryEditCmd $params)
 * @method deleteAnnouncementCategoryByParams(array $params)
 * @method getAnnouncementCategoryByParams(array $params)
 */
class Announcement {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取公告列表
     *
     * @var  \Mainto\Bridge\Structs\HimoMicroNotify\Notify\Cmd\Announcement\AnnouncementSearchCmd $announcementSearchCmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\HimoMicroNotify\Notify\DTO\AnnouncementDTO\AnnouncementDTO[]
     */
    public static function announcementList (\Mainto\Bridge\Structs\HimoMicroNotify\Notify\Cmd\Announcement\AnnouncementSearchCmd $announcementSearchCmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->announcementList($announcementSearchCmd),
            "\Mainto\Bridge\Structs\HimoMicroNotify\Notify\DTO\AnnouncementDTO\AnnouncementDTO[]"
        );
    }


    /**
     * 获取公告列表(分页)
     *
     * @var  \Mainto\Bridge\Structs\HimoMicroNotify\Notify\Cmd\Announcement\AnnouncementSearchCmd $announcementSearchCmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\HimoMicroNotify\Notify\DTO\AnnouncementDTO\AnnouncementListWithPageDTO
     */
    public static function announcementListWithPage (\Mainto\Bridge\Structs\HimoMicroNotify\Notify\Cmd\Announcement\AnnouncementSearchCmd $announcementSearchCmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->announcementListWithPage($announcementSearchCmd),
            "\Mainto\Bridge\Structs\HimoMicroNotify\Notify\DTO\AnnouncementDTO\AnnouncementListWithPageDTO"
        );
    }


    /**
     * 创建公告
     *
     * @var  \Mainto\Bridge\Structs\HimoMicroNotify\Notify\Cmd\Announcement\AnnouncementCreateCmd $announcementCreateCmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\HimoMicroNotify\Notify\DTO\AnnouncementDTO\AnnouncementDTO
     */
    public static function createAnnouncement (\Mainto\Bridge\Structs\HimoMicroNotify\Notify\Cmd\Announcement\AnnouncementCreateCmd $announcementCreateCmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->createAnnouncement($announcementCreateCmd),
            "\Mainto\Bridge\Structs\HimoMicroNotify\Notify\DTO\AnnouncementDTO\AnnouncementDTO"
        );
    }


    /**
     * 编辑公告
     *
     * @var  \Mainto\Bridge\Structs\HimoMicroNotify\Notify\Cmd\Announcement\AnnouncementEditCmd $announcementEditCmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\HimoMicroNotify\Notify\DTO\AnnouncementDTO\AnnouncementDTO
     */
    public static function editAnnouncement (\Mainto\Bridge\Structs\HimoMicroNotify\Notify\Cmd\Announcement\AnnouncementEditCmd $announcementEditCmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->editAnnouncement($announcementEditCmd),
            "\Mainto\Bridge\Structs\HimoMicroNotify\Notify\DTO\AnnouncementDTO\AnnouncementDTO"
        );
    }


    /**
     * 公告详情
     *
     * @param  int $id 公告id [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\HimoMicroNotify\Notify\DTO\AnnouncementDTO\AnnouncementDTO
     */
    public static function announcementDetail (int $id) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->announcementDetail([
                            "id" => $id,
                        ]),
            "\Mainto\Bridge\Structs\HimoMicroNotify\Notify\DTO\AnnouncementDTO\AnnouncementDTO"
        );
    }

    /**
     * 作废公告
     *
     * @param  int $id 公告id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function abolish (int $id) {
        return self::getClass()->abolish([
            "id" => $id,
        ]);
    }

    /**
     * 导出公告阅读报告
     *
     * @param  array $messageIds 公告id列表 [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\HimoMicroNotify\Notify\DTO\AnnouncementDTO\ReadRecordDTO[]
     */
    public static function exportReadReport (array $messageIds) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->exportReadReport([
                            "messageIds" => $messageIds,
                        ]),
            "\Mainto\Bridge\Structs\HimoMicroNotify\Notify\DTO\AnnouncementDTO\ReadRecordDTO[]"
        );
    }

    /**
     * 获取指定日期的弹窗
     *
     * @param  string $date 日期 [ require true ]
     * @param  int $reader 读取人 [ require false ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\HimoMicroNotify\Notify\DTO\AnnouncementDTO\AnnouncementDTO[]
     */
    public static function getPops (string $date, int $reader = 0) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getPops([
                            "date" => $date,
                            "reader" => $reader,
                        ]),
            "\Mainto\Bridge\Structs\HimoMicroNotify\Notify\DTO\AnnouncementDTO\AnnouncementDTO[]"
        );
    }

    /**
     * 获取已读消息列表
     *
     * @param  array $messageIds 消息主键id数组 [ require false ]
     * @param  int $reader 读取人 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getReadMessages (int $reader, array $messageIds = []) {
        return self::getClass()->getReadMessages([
            "reader" => $reader,
            "messageIds" => $messageIds,
        ]);
    }

    /**
     * 读公告
     *
     * @param  int $reader 读者id [ require true ]
     * @param  int $messageId 公告主键id [ require true ]
     * @param  string $readerType 读者类型 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function readAnnouncement (int $reader, int $messageId, string $readerType) {
        return self::getClass()->readAnnouncement([
            "reader" => $reader,
            "messageId" => $messageId,
            "readerType" => $readerType,
        ]);
    }

    /**
     * 置顶
     *
     * @param  int $id 公告主键id [ require true ]
     * @param  array $modules 模块ids [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function top (int $id, array $modules) {
        return self::getClass()->top([
            "id" => $id,
            "modules" => $modules,
        ]);
    }

    /**
     * 创建公告板块
     *
     * @param  string $name 板块名称 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function createAnnouncementCategory (string $name) {
        return self::getClass()->createAnnouncementCategory([
            "name" => $name,
        ]);
    }

    /**
     * 编辑公告板块
     *
     * @var  \Mainto\Bridge\Structs\HimoMicroNotify\Notify\Cmd\Announcement\AnnouncementCategoryEditCmd $categoryCmd
     * @throws  \Exception
     * @return  bool
     */
    public static function editAnnouncementCategory (\Mainto\Bridge\Structs\HimoMicroNotify\Notify\Cmd\Announcement\AnnouncementCategoryEditCmd $categoryCmd) {
        return self::getClass()->editAnnouncementCategory($categoryCmd);
    }


    /**
     * 删除公告板块
     *
     * @param  int $id 公告id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function deleteAnnouncementCategory (int $id) {
        return self::getClass()->deleteAnnouncementCategory([
            "id" => $id,
        ]);
    }

    /**
     * 获取公告板块
     *
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\HimoMicroNotify\Notify\DTO\AnnouncementDTO\AnnouncementCategoryDTO[]
     */
    public static function getAnnouncementCategory () {
        return self::getClass()->getAnnouncementCategory();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoMicroNotify', 'Notify\Announcement');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoMicroNotify', 'Notify\Announcement');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}