<?php
namespace Mainto\Bridge\Invokes\HimoMicroNotify\Notify;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method sendSmsNotifyByParams(array|\Mainto\Bridge\Structs\HimoMicroNotify\Notify\Cmd\Sms\SendSmsNotifyCmd $params)
 */
class Sms {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 发送短信通知
     *
     * @var  \Mainto\Bridge\Structs\HimoMicroNotify\Notify\Cmd\Sms\SendSmsNotifyCmd $cmd
     * @throws  \Exception
     * @return  bool
     */
    public static function sendSmsNotify (\Mainto\Bridge\Structs\HimoMicroNotify\Notify\Cmd\Sms\SendSmsNotifyCmd $cmd) {
        return self::getClass()->sendSmsNotify($cmd);
    }


    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoMicroNotify', 'Notify\Sms');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoMicroNotify', 'Notify\Sms');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}