<?php
namespace Mainto\Bridge\Invokes\HimoMicroNotify\Notify;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getMessageByParams(array $params)
 * @method hookAsyncSendByParams(array $params)
 */
class Notify {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getMessage
     *
     * @param  string $messageId messageId [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\HimoMicroNotify\Notify\DTO\MessageDTO
     */
    public static function getMessage (string $messageId) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getMessage([
                            "messageId" => $messageId,
                        ]),
            "\Mainto\Bridge\Structs\HimoMicroNotify\Notify\DTO\MessageDTO"
        );
    }

    /**
     * hookAsyncSend
     *
     * @param  string $messageId 消息id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function hookAsyncSend (string $messageId) {
        return self::getClass()->hookAsyncSend([
            "messageId" => $messageId,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoMicroNotify', 'Notify\Notify');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoMicroNotify', 'Notify\Notify');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}