<?php
namespace Mainto\Bridge\Invokes\HimoMicroNotify\Notify;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method callbackByParams(array|\Mainto\Bridge\Structs\HimoMicroNotify\Notify\Cmd\CallbackCmd $params)
 * @method hookByParams(array $params)
 * @method sendInteractiveCardByParams(array|\Mainto\Bridge\Structs\HimoMicroNotify\Notify\Cmd\SendInteractiveCardCmd $params)
 * @method updateInteractiveCardCmdByParams(array|\Mainto\Bridge\Structs\HimoMicroNotify\Notify\Cmd\UpdateInteractiveCardCmd $params)
 * @method getInteractiveCardMessageByParams(array $params)
 */
class Dingtalk {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * hook 事件回调
     *
     * @var  \Mainto\Bridge\Structs\HimoMicroNotify\Notify\Cmd\CallbackCmd $cmd
     * @throws  \Exception
     * @return  string
     */
    public static function callback (\Mainto\Bridge\Structs\HimoMicroNotify\Notify\Cmd\CallbackCmd $cmd) {
        return self::getClass()->callback($cmd);
    }


    /**
     * hook 消息回调
     *
     * @throws  \Exception
     * @return  string
     */
    public static function hook ($context) {
        return self::getClass()->hook();
    }

    /**
     * sendInteractiveCard
     *
     * @var  \Mainto\Bridge\Structs\HimoMicroNotify\Notify\Cmd\SendInteractiveCardCmd $cmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\HimoMicroNotify\Notify\DTO\InteractiveCardMessageDTO
     */
    public static function sendInteractiveCard (\Mainto\Bridge\Structs\HimoMicroNotify\Notify\Cmd\SendInteractiveCardCmd $cmd) {
        return RpcDefinition::getInstance()->getMapper()->mapUseTypeString(
            self::getClass()->sendInteractiveCard($cmd),
            "\Mainto\Bridge\Structs\HimoMicroNotify\Notify\DTO\InteractiveCardMessageDTO"
        );
    }


    /**
     * 修改要将原内容都传过来
     *
     * @var  \Mainto\Bridge\Structs\HimoMicroNotify\Notify\Cmd\UpdateInteractiveCardCmd $cmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\HimoMicroNotify\Notify\DTO\InteractiveCardMessageDTO
     */
    public static function updateInteractiveCardCmd (\Mainto\Bridge\Structs\HimoMicroNotify\Notify\Cmd\UpdateInteractiveCardCmd $cmd) {
        return RpcDefinition::getInstance()->getMapper()->mapUseTypeString(
            self::getClass()->updateInteractiveCardCmd($cmd),
            "\Mainto\Bridge\Structs\HimoMicroNotify\Notify\DTO\InteractiveCardMessageDTO"
        );
    }


    /**
     * getInteractiveCardMessage
     *
     * @param  string $messageId messageId [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\HimoMicroNotify\Notify\DTO\InteractiveCardMessageDTO
     */
    public static function getInteractiveCardMessage (string $messageId) {
        return RpcDefinition::getInstance()->getMapper()->mapUseTypeString(
            self::getClass()->getInteractiveCardMessage([
                            "messageId" => $messageId,
                        ]),
            "\Mainto\Bridge\Structs\HimoMicroNotify\Notify\DTO\InteractiveCardMessageDTO"
        );
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoMicroNotify', 'Notify\Dingtalk');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoMicroNotify', 'Notify\Dingtalk');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}