<?php
namespace Mainto\Bridge\Invokes\HimoMicroNotify\DingTalkController;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method callbackByParams(array|\Mainto\Bridge\Structs\HimoMicroNotify\DingTalkController\Cmd\CallbackCmd $params)
 * @method sendInteractiveCardByParams(array|\Mainto\Bridge\Structs\HimoMicroNotify\DingTalkController\Cmd\SendInteractiveCardCmd $params)
 */
class DingTalk {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * callback
     *
     * @var  \Mainto\Bridge\Structs\HimoMicroNotify\DingTalkController\Cmd\CallbackCmd $cmd
     * @throws  \Exception
     * @return  string
     */
    public static function callback (\Mainto\Bridge\Structs\HimoMicroNotify\DingTalkController\Cmd\CallbackCmd $cmd) {
        return self::getClass()->callback($cmd);
    }


    /**
     * sendInteractiveCard
     *
     * @var  \Mainto\Bridge\Structs\HimoMicroNotify\DingTalkController\Cmd\SendInteractiveCardCmd $cmd
     * @throws  \Exception
     * @return  mixed
     */
    public static function sendInteractiveCard (\Mainto\Bridge\Structs\HimoMicroNotify\DingTalkController\Cmd\SendInteractiveCardCmd $cmd) {
        return self::getClass()->sendInteractiveCard($cmd);
    }


    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoMicroNotify', 'DingTalkController\DingTalk');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoMicroNotify', 'DingTalkController\DingTalk');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}