<?php
namespace Mainto\Bridge\Invokes\HimoMicroNotify\Dingtalk;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method callbackByParams(array|\Mainto\Bridge\Structs\HimoMicroNotify\Dingtalk\Cmd\CallbackCmd $params)
 * @method sendInteractiveCardByParams(array|\Mainto\Bridge\Structs\HimoMicroNotify\Dingtalk\Cmd\SendInteractiveCardCmd $params)
 * @method updateInteractiveCardCmdByParams(array|\Mainto\Bridge\Structs\HimoMicroNotify\Dingtalk\Cmd\UpdateInteractiveCardCmd $params)
 */
class Dingtalk {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * callback
     *
     * @var  \Mainto\Bridge\Structs\HimoMicroNotify\Dingtalk\Cmd\CallbackCmd $cmd
     * @throws  \Exception
     * @return  string
     */
    public static function callback (\Mainto\Bridge\Structs\HimoMicroNotify\Dingtalk\Cmd\CallbackCmd $cmd) {
        return self::getClass()->callback($cmd);
    }


    /**
     * sendInteractiveCard
     *
     * @var  \Mainto\Bridge\Structs\HimoMicroNotify\Dingtalk\Cmd\SendInteractiveCardCmd $cmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\HimoMicroNotify\Dingtalk\DTO\MessageDTO
     */
    public static function sendInteractiveCard (\Mainto\Bridge\Structs\HimoMicroNotify\Dingtalk\Cmd\SendInteractiveCardCmd $cmd) {
        return RpcDefinition::getInstance()->getMapper()->mapUseTypeString(
            self::getClass()->sendInteractiveCard($cmd),
            "\Mainto\Bridge\Structs\HimoMicroNotify\Dingtalk\DTO\MessageDTO"
        );
    }


    /**
     * 修改要将原内容都传过来
     *
     * @var  \Mainto\Bridge\Structs\HimoMicroNotify\Dingtalk\Cmd\UpdateInteractiveCardCmd $cmd
     * @throws  \Exception
     * @return  bool
     */
    public static function updateInteractiveCardCmd (\Mainto\Bridge\Structs\HimoMicroNotify\Dingtalk\Cmd\UpdateInteractiveCardCmd $cmd) {
        return self::getClass()->updateInteractiveCardCmd($cmd);
    }


    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoMicroNotify', 'Dingtalk\Dingtalk');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoMicroNotify', 'Dingtalk\Dingtalk');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}