<?php
namespace Mainto\Bridge\Invokes\HimoMicroMaterial\Rpc;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method initCampaignByParams(array $params)
 * @method saveCampaignTemplateByParams(array|\Mainto\Bridge\Structs\HimoMicroMaterial\Rpc\Cmd\Campaign\SaveCampaignTemplateCMD $params)
 * @method updateCampaignStatusByParams(array $params)
 * @method deleteCampaignByParams(array $params)
 * @method getCampaignTemplateByParams(array $params)
 * @method campaignListByParams(array|\Mainto\Bridge\Structs\HimoMicroMaterial\Rpc\Cmd\Campaign\CampaignListCMD $params)
 */
class Campaign {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 初始化活动
     *
     * @throws  \Exception
     * @return  int
     */
    public static function initCampaign () {
        return self::getClass()->initCampaign();
    }

    /**
     * 保存活动模版
     *
     * @var  \Mainto\Bridge\Structs\HimoMicroMaterial\Rpc\Cmd\Campaign\SaveCampaignTemplateCMD $saveCampaignTemplateCmd
     * @throws  \Exception
     * @return  bool
     */
    public static function saveCampaignTemplate (\Mainto\Bridge\Structs\HimoMicroMaterial\Rpc\Cmd\Campaign\SaveCampaignTemplateCMD $saveCampaignTemplateCmd) {
        return self::getClass()->saveCampaignTemplate($saveCampaignTemplateCmd);
    }


    /**
     * 更新活动状态
     *
     * @param  int $campaignId 活动ID [ require true ]
     * @param  string $status 活动状态 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function updateCampaignStatus (int $campaignId, string $status) {
        return self::getClass()->updateCampaignStatus([
            "campaignId" => $campaignId,
            "status" => $status,
        ]);
    }

    /**
     * 删除活动
     *
     * @param  int $campaignId 活动ID [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function deleteCampaign (int $campaignId) {
        return self::getClass()->deleteCampaign([
            "campaignId" => $campaignId,
        ]);
    }

    /**
     * 获取活动模版详情
     *
     * @param  int $campaignId 活动ID [ require true ]
     * @param  string $versionStatus 活动模版状态 [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\HimoMicroMaterial\Rpc\DTO\CampaignDTO\CampaignDTO
     */
    public static function getCampaignTemplate (int $campaignId, string $versionStatus) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getCampaignTemplate([
                            "campaignId" => $campaignId,
                            "versionStatus" => $versionStatus,
                        ]),
            "\Mainto\Bridge\Structs\HimoMicroMaterial\Rpc\DTO\CampaignDTO\CampaignDTO"
        );
    }

    /**
     * 活动列表
     *
     * @var  \Mainto\Bridge\Structs\HimoMicroMaterial\Rpc\Cmd\Campaign\CampaignListCMD $campaignListCMD
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\HimoMicroMaterial\Rpc\DTO\CampaignDTO\CampaignListDTO
     */
    public static function campaignList (\Mainto\Bridge\Structs\HimoMicroMaterial\Rpc\Cmd\Campaign\CampaignListCMD $campaignListCMD) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->campaignList($campaignListCMD),
            "\Mainto\Bridge\Structs\HimoMicroMaterial\Rpc\DTO\CampaignDTO\CampaignListDTO"
        );
    }


    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoMicroMaterial', 'Rpc\Campaign');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoMicroMaterial', 'Rpc\Campaign');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}