<?php
namespace Mainto\Bridge\Invokes\HimoMicroMaterial\Rpc;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method pictureTagsByParams(array $params)
 * @method getPictureTagListByParams(array|\Mainto\Bridge\Structs\HimoMicroMaterial\Rpc\Cmd\Material\PictureTagListCmd $params)
 */
class PictureTag {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获得素材标签树
     *
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\HimoMicroMaterial\Rpc\DTO\MaterialDTO\PictureTagDTO[]
     */
    public static function pictureTags () {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->pictureTags(),
            "\Mainto\Bridge\Structs\HimoMicroMaterial\Rpc\DTO\MaterialDTO\PictureTagDTO[]"
        );
    }

    /**
     * 获得标签列表数据
     *
     * @var  \Mainto\Bridge\Structs\HimoMicroMaterial\Rpc\Cmd\Material\PictureTagListCmd $pictureTagListCmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\HimoMicroMaterial\Rpc\DTO\MaterialDTO\PictureTagDTO[]
     */
    public static function getPictureTagList (\Mainto\Bridge\Structs\HimoMicroMaterial\Rpc\Cmd\Material\PictureTagListCmd $pictureTagListCmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getPictureTagList($pictureTagListCmd),
            "\Mainto\Bridge\Structs\HimoMicroMaterial\Rpc\DTO\MaterialDTO\PictureTagDTO[]"
        );
    }


    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoMicroMaterial', 'Rpc\PictureTag');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoMicroMaterial', 'Rpc\PictureTag');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}