<?php
namespace Mainto\Bridge\Invokes\HimoMicroMaterial\Rpc;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method addMaterialByParams(array|\Mainto\Bridge\Structs\HimoMicroMaterial\Rpc\Cmd\Material\MaterialCmd $params)
 * @method updateStatusByParams(array $params)
 * @method materialInfoByParams(array $params)
 * @method updateInfoByParams(array|\Mainto\Bridge\Structs\HimoMicroMaterial\Rpc\Cmd\Material\SaveMaterialCmd $params)
 * @method deleteByParams(array $params)
 * @method materialListByParams(array|\Mainto\Bridge\Structs\HimoMicroMaterial\Rpc\Cmd\Material\MaterialListCmd $params)
 * @method batchAddByParams(array|\Mainto\Bridge\Structs\HimoMicroMaterial\Rpc\Cmd\Material\BatchAddMaterialCmd $params)
 */
class Material {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 添加素材
     *
     * @var  \Mainto\Bridge\Structs\HimoMicroMaterial\Rpc\Cmd\Material\MaterialCmd $materialCmd
     * @throws  \Exception
     * @return  bool
     */
    public static function addMaterial (\Mainto\Bridge\Structs\HimoMicroMaterial\Rpc\Cmd\Material\MaterialCmd $materialCmd) {
        return self::getClass()->addMaterial($materialCmd);
    }


    /**
     * 更新素材状态
     *
     * @param  int $materialId 素材ID [ require true ]
     * @param  string $status 素材状态 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function updateStatus (int $materialId, string $status) {
        return self::getClass()->updateStatus([
            "materialId" => $materialId,
            "status" => $status,
        ]);
    }

    /**
     * 素材详情
     *
     * @param  int $materialId 素材ID [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\HimoMicroMaterial\Rpc\DTO\MaterialDTO\MaterialDTO
     */
    public static function materialInfo (int $materialId) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->materialInfo([
                            "materialId" => $materialId,
                        ]),
            "\Mainto\Bridge\Structs\HimoMicroMaterial\Rpc\DTO\MaterialDTO\MaterialDTO"
        );
    }

    /**
     * 更新素材信息
     *
     * @var  \Mainto\Bridge\Structs\HimoMicroMaterial\Rpc\Cmd\Material\SaveMaterialCmd $saveMaterialCmd
     * @throws  \Exception
     * @return  bool
     */
    public static function updateInfo (\Mainto\Bridge\Structs\HimoMicroMaterial\Rpc\Cmd\Material\SaveMaterialCmd $saveMaterialCmd) {
        return self::getClass()->updateInfo($saveMaterialCmd);
    }


    /**
     * 删除素材信息
     *
     * @param  int $materialId 素材ID [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function delete (int $materialId) {
        return self::getClass()->delete([
            "materialId" => $materialId,
        ]);
    }

    /**
     * 素材信息列表
     *
     * @var  \Mainto\Bridge\Structs\HimoMicroMaterial\Rpc\Cmd\Material\MaterialListCmd $materialListCmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\HimoMicroMaterial\Rpc\DTO\MaterialDTO\MaterialListDTO
     */
    public static function materialList (\Mainto\Bridge\Structs\HimoMicroMaterial\Rpc\Cmd\Material\MaterialListCmd $materialListCmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->materialList($materialListCmd),
            "\Mainto\Bridge\Structs\HimoMicroMaterial\Rpc\DTO\MaterialDTO\MaterialListDTO"
        );
    }


    /**
     * 批量添加
     *
     * @var  \Mainto\Bridge\Structs\HimoMicroMaterial\Rpc\Cmd\Material\BatchAddMaterialCmd $batchAddMaterialCmd
     * @throws  \Exception
     * @return  bool
     */
    public static function batchAdd (\Mainto\Bridge\Structs\HimoMicroMaterial\Rpc\Cmd\Material\BatchAddMaterialCmd $batchAddMaterialCmd) {
        return self::getClass()->batchAdd($batchAddMaterialCmd);
    }


    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoMicroMaterial', 'Rpc\Material');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoMicroMaterial', 'Rpc\Material');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}