<?php
namespace Mainto\Bridge\Invokes\HimoMicroMaterial\App\Interfaces\Rpc\Controllers;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method addMaterialByParams(array|Material\AddMaterial\MaterialCmd $params)
 * @method updateStatusByParams(array $params)
 * @method materialInfoByParams(array $params)
 * @method updateInfoByParams(array|Material\UpdateInfo\SaveMaterialCmd $params)
 * @method deleteByParams(array $params)
 * @method materialListByParams(array|Material\MaterialList\MaterialListCmd $params)
 * @method batchAddByParams(array|Material\BatchAdd\BatchAddMaterialCmd $params)
 */
class Material {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 添加素材
     *
     * @var  Material\AddMaterial\MaterialCmd $materialCmd $materialCmd
     * @throws  \Exception
     * @return  bool
     */
    public static function addMaterial (Material\AddMaterial\MaterialCmd $materialCmd) {
        return self::getClass()->addMaterial($materialCmd);
    }


    /**
     * 更新素材状态
     *
     * @param  int $materialId 素材ID [ require true ]
     * @param  string $status 素材状态 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function updateStatus (int $materialId, string $status) {
        return self::getClass()->updateStatus([
            "materialId" => $materialId,
            "status" => $status,
        ]);
    }

    /**
     * 素材详情
     *
     * @param  int $materialId 素材ID [ require true ]
     * @throws  \Exception
     * @return  Material\MaterialInfo\MaterialDTO
     */
    public static function materialInfo (int $materialId) {
        return RpcDefinition::getInstance()->getMapper()->mapUseTypeString(
            self::getClass()->materialInfo([
                            "materialId" => $materialId,
                        ]),
            "\Mainto\Bridge\Invokes\HimoMicroMaterial\App\Interfaces\Rpc\Controllers\Material\MaterialInfo\MaterialDTO"
        );
    }

    /**
     * 更新素材信息
     *
     * @var  Material\UpdateInfo\SaveMaterialCmd $saveMaterialCmd $saveMaterialCmd
     * @throws  \Exception
     * @return  bool
     */
    public static function updateInfo (Material\UpdateInfo\SaveMaterialCmd $saveMaterialCmd) {
        return self::getClass()->updateInfo($saveMaterialCmd);
    }


    /**
     * 删除素材信息
     *
     * @param  int $materialId 素材ID [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function delete (int $materialId) {
        return self::getClass()->delete([
            "materialId" => $materialId,
        ]);
    }

    /**
     * 素材信息列表
     *
     * @var  Material\MaterialList\MaterialListCmd $materialListCmd $materialListCmd
     * @throws  \Exception
     * @return  Material\MaterialList\MaterialListDTO
     */
    public static function materialList (Material\MaterialList\MaterialListCmd $materialListCmd) {
        return RpcDefinition::getInstance()->getMapper()->mapUseTypeString(
            self::getClass()->materialList($materialListCmd),
            "\Mainto\Bridge\Invokes\HimoMicroMaterial\App\Interfaces\Rpc\Controllers\Material\MaterialList\MaterialListDTO"
        );
    }


    /**
     * 批量添加
     *
     * @var  Material\BatchAdd\BatchAddMaterialCmd $batchAddMaterialCmd $batchAddMaterialCmd
     * @throws  \Exception
     * @return  bool
     */
    public static function batchAdd (Material\BatchAdd\BatchAddMaterialCmd $batchAddMaterialCmd) {
        return self::getClass()->batchAdd($batchAddMaterialCmd);
    }


    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoMicroMaterial', 'Rpc\Material');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoMicroMaterial', 'Rpc\Material');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}