<?php
namespace Mainto\Bridge\Invokes\HimoMicroMaterial\App\Interfaces\Rpc\Controllers;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method addMaterialByParams(array|AddMaterial\MaterialCommand $params)
 * @method updateStatusByParams(array $params)
 * @method materialInfoByParams(array $params)
 * @method deletedByParams(array $params)
 * @method updateInfoByParams(array|UpdateInfo\SaveMaterialCommand $params)
 * @method materialListByParams(array|MaterialList\MaterialListCommand $params)
 * @method batchAddByParams(array|BatchAdd\BatchAddMaterialCommand $params)
 */
class Material {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 添加素材
     *
     * @var  AddMaterial\MaterialCommand $materialCommand $materialCommand
     * @throws  \Exception
     * @return  bool
     */
    public static function addMaterial (AddMaterial\MaterialCommand $materialCommand) {
        return self::getClass()->addMaterial($materialCommand);
    }


    /**
     * 更新素材状态
     *
     * @param  int $materialId 素材ID [ require true ]
     * @param  string $status 素材状态 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function updateStatus (int $materialId, string $status) {
        return self::getClass()->updateStatus([
            "materialId" => $materialId,
            "status" => $status,
        ]);
    }

    /**
     * 素材详情
     *
     * @param  int $materialId 素材ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function materialInfo (int $materialId) {
        return self::getClass()->materialInfo([
            "materialId" => $materialId,
        ]);
    }

    /**
     * 删除素材信息
     *
     * @param  int $materialId 素材ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function deleted (int $materialId) {
        return self::getClass()->deleted([
            "materialId" => $materialId,
        ]);
    }

    /**
     * 更新素材信息
     *
     * @var  UpdateInfo\SaveMaterialCommand $saveMaterialCommand $saveMaterialCommand
     * @throws  \Exception
     * @return  mixed
     */
    public static function updateInfo (UpdateInfo\SaveMaterialCommand $saveMaterialCommand) {
        return self::getClass()->updateInfo($saveMaterialCommand);
    }


    /**
     * 素材信息列表
     *
     * @var  MaterialList\MaterialListCommand $materialListCommand $materialListCommand
     * @throws  \Exception
     * @return  mixed
     */
    public static function materialList (MaterialList\MaterialListCommand $materialListCommand) {
        return self::getClass()->materialList($materialListCommand);
    }


    /**
     * 批量添加
     *
     * @var  BatchAdd\BatchAddMaterialCommand $BatchAddMaterialCommand $BatchAddMaterialCommand
     * @throws  \Exception
     * @return  mixed
     */
    public static function batchAdd (BatchAdd\BatchAddMaterialCommand $BatchAddMaterialCommand) {
        return self::getClass()->batchAdd($BatchAddMaterialCommand);
    }


    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoMicroMaterial', 'Material');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoMicroMaterial', 'Material');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}