<?php
namespace Mainto\Bridge\Invokes\HimoMicroDiscuss\HappinessPhotoStudio;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method listWishByParams(array $params)
 * @method addWishByParams(array $params)
 * @method editWishByParams(array $params)
 * @method getWishByParams(array $params)
 * @method deleteWishByParams(array $params)
 * @method likeWishByParams(array $params)
 * @method likeWishCancelByParams(array $params)
 */
class Wish {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 心愿列表
     *
     * @support  int $userId 用户id [ require false ]
     * @support  int $likeUserId 点赞的用户id [ require false ]
     * @support  string $status 状态 [ require false ]
     * @support  string $phone 手机帐号 [ require false ]
     * @support  string $startDay 开始日期 [ require false ]
     * @support  string $endDay 结束日期 [ require false ]
     * @support  int $page 页数 [ require false ]
     * @support  int $pageSize 分页数 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function listWish () {
        return self::getClass()->listWish([
        ]);
    }

    /**
     * 心愿新增
     *
     * @support  int $userId 用户id [ require true ]
     * @support  string $phone 用户帐号 [ require true ]
     * @support  string $content 心愿内容 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function addWish () {
        return self::getClass()->addWish([
        ]);
    }

    /**
     * 心愿编辑
     *
     * @support  int $id 心愿id [ require true ]
     * @support  string $content 心愿内容 [ require false ]
     * @support  string $status 心愿状态 [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function editWish () {
        return self::getClass()->editWish([
        ]);
    }

    /**
     * 心愿详情
     *
     * @support  int $id 心愿id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getWish () {
        return self::getClass()->getWish([
        ]);
    }

    /**
     * 心愿删除
     *
     * @support  int $id 心愿id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function deleteWish () {
        return self::getClass()->deleteWish([
        ]);
    }

    /**
     * 心愿点赞
     *
     * @support  int $wishId 心愿id [ require true ]
     * @support  int $userId 用户id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function likeWish () {
        return self::getClass()->likeWish([
        ]);
    }

    /**
     * 心愿点赞取消
     *
     * @support  int $wishId 心愿id [ require true ]
     * @support  int $userId 用户id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function likeWishCancel () {
        return self::getClass()->likeWishCancel([
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoMicroDiscuss', 'HappinessPhotoStudio\Wish');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoMicroDiscuss', 'HappinessPhotoStudio\Wish');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}