<?php
namespace Mainto\Bridge\Invokes\HimoMicroDiscuss;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method addTopicByParams(array|\Mainto\Bridge\Structs\HimoMicroDiscuss\Cmd\Topic\AddTopicCmd $params)
 * @method updateTopicByParams(array|\Mainto\Bridge\Structs\HimoMicroDiscuss\Cmd\Topic\UpdateTopicCmd $params)
 * @method topicDetailByParams(array $params)
 * @method topicListByParams(array|\Mainto\Bridge\Structs\HimoMicroDiscuss\Cmd\Topic\TopicListCmd $params)
 */
class Topic {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 添加话题
     *
     * @var  \Mainto\Bridge\Structs\HimoMicroDiscuss\Cmd\Topic\AddTopicCmd $addTopicCmd
     * @throws  \Exception
     * @return  bool
     */
    public static function addTopic (\Mainto\Bridge\Structs\HimoMicroDiscuss\Cmd\Topic\AddTopicCmd $addTopicCmd) {
        return self::getClass()->addTopic($addTopicCmd);
    }


    /**
     * 更新话题信息
     *
     * @var  \Mainto\Bridge\Structs\HimoMicroDiscuss\Cmd\Topic\UpdateTopicCmd $updateTopicCmd
     * @throws  \Exception
     * @return  bool
     */
    public static function updateTopic (\Mainto\Bridge\Structs\HimoMicroDiscuss\Cmd\Topic\UpdateTopicCmd $updateTopicCmd) {
        return self::getClass()->updateTopic($updateTopicCmd);
    }


    /**
     * 话题详情
     *
     * @param  int $topicId 话题id [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\HimoMicroDiscuss\DTO\Topic\TopicInfoDTO
     */
    public static function topicDetail (int $topicId) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->topicDetail([
                            "topicId" => $topicId,
                        ]),
            "\Mainto\Bridge\Structs\HimoMicroDiscuss\DTO\Topic\TopicInfoDTO"
        );
    }

    /**
     * 话题列表
     *
     * @var  \Mainto\Bridge\Structs\HimoMicroDiscuss\Cmd\Topic\TopicListCmd $topicListCmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\HimoMicroDiscuss\DTO\Topic\TopicListDTO
     */
    public static function topicList (\Mainto\Bridge\Structs\HimoMicroDiscuss\Cmd\Topic\TopicListCmd $topicListCmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->topicList($topicListCmd),
            "\Mainto\Bridge\Structs\HimoMicroDiscuss\DTO\Topic\TopicListDTO"
        );
    }


    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoMicroDiscuss', 'Topic');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoMicroDiscuss', 'Topic');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}