<?php
namespace Mainto\Bridge\Invokes\HimoMicroDiscuss\HappinessPhotoStudio;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createHappinessArticleByParams(array $params)
 * @method getHappinessArticleByParams(array $params)
 * @method happinessArticleListByParams(array $params)
 * @method deleteHappinessArticleByParams(array $params)
 * @method editHappinessArticleByParams(array $params)
 * @method incrementLikeNumByParams(array $params)
 * @method decrementLikeNumByParams(array $params)
 */
class HappinessArticleRecord {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 添加分享文章
     *
     * @support  int $userId 用户ID [ require true ]
     * @support  string $phone 用户手机号码 [ require true ]
     * @support  string $coverImg 封面图片 [ require true ]
     * @support  string $title 标题 [ require true ]
     * @support  array $articleImgs 文章配图 [ require true ]
     * @support  string $article 文章 [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function createHappinessArticle () {
        return self::getClass()->createHappinessArticle([
        ]);
    }

    /**
     * 分享文章详情
     *
     * @support  int $articleId 文章ID [ require true ]
     * @support  int $likeUserId 点赞用户ID [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getHappinessArticle () {
        return self::getClass()->getHappinessArticle([
        ]);
    }

    /**
     * 分享文章列表
     *
     * @support  int $page 页码 [ require true ]
     * @support  int $pageSize 每页条数 [ require true ]
     * @support  string $createAtStart 创建时间开始 [ require false ]
     * @support  string $createAtEnd 创建时间结束 [ require false ]
     * @support  string $phone 用户手机号码 [ require false ]
     * @support  int $userId 用户ID [ require false ]
     * @support  int $likeUserId 点赞用户ID [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function happinessArticleList () {
        return self::getClass()->happinessArticleList([
        ]);
    }

    /**
     * 删除分享文章
     *
     * @support  int $articleId 文章ID [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function deleteHappinessArticle () {
        return self::getClass()->deleteHappinessArticle([
        ]);
    }

    /**
     * 编辑分享文章
     *
     * @support  int $articleId 用户ID [ require true ]
     * @support  string $coverImg 封面图片 [ require true ]
     * @support  string $title 标题 [ require true ]
     * @support  array $articleImgs 文章配图 [ require true ]
     * @support  string $article 文章 [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function editHappinessArticle () {
        return self::getClass()->editHappinessArticle([
        ]);
    }

    /**
     * 点赞
     *
     * @support  int $articleId 文章ID [ require true ]
     * @support  int $userId 用户ID [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function incrementLikeNum () {
        return self::getClass()->incrementLikeNum([
        ]);
    }

    /**
     * 取消点赞
     *
     * @support  int $articleId 文章ID [ require true ]
     * @support  int $userId 用户ID [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function decrementLikeNum () {
        return self::getClass()->decrementLikeNum([
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoMicroDiscuss', 'HappinessPhotoStudio\HappinessArticleRecord');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoMicroDiscuss', 'HappinessPhotoStudio\HappinessArticleRecord');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}