<?php
namespace Mainto\Bridge\Invokes\HimoMicroDiscuss\HappinessPhotoStudio;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getHappinessArticleLikeByParams(array $params)
 * @method getHappinessArticleLikeListByParams(array $params)
 */
class HappinessArticleLikeRecord {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 分享文章点赞
     *
     * @support  int $userId 用户ID [ require true ]
     * @support  int $articleId 文章ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getHappinessArticleLike () {
        return self::getClass()->getHappinessArticleLike([
        ]);
    }

    /**
     * 分享文章点赞列表
     *
     * @support  int $userId 用户ID [ require true ]
     * @support  array $articleIds 文章ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getHappinessArticleLikeList () {
        return self::getClass()->getHappinessArticleLikeList([
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoMicroDiscuss', 'HappinessPhotoStudio\HappinessArticleLikeRecord');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoMicroDiscuss', 'HappinessPhotoStudio\HappinessArticleLikeRecord');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}