<?php
namespace Mainto\Bridge\Invokes\HimoMicroDiscuss\HappinessPhotoStudio;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method listArticleByParams(array $params)
 * @method addArticleByParams(array $params)
 * @method editArticleByParams(array $params)
 * @method getArticleByParams(array $params)
 * @method deleteArticleByParams(array $params)
 */
class Article {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 文章列表
     *
     * @support  string $title 标题关键词 [ require false ]
     * @support  string $status 状态 [ require false ]
     * @support  string $label 标签 [ require false ]
     * @support  string $startDay 开始日期 [ require false ]
     * @support  string $endDay 结束日期 [ require false ]
     * @support  int $page 页数 [ require false ]
     * @support  int $pageSize 分页数 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function listArticle () {
        return self::getClass()->listArticle([
        ]);
    }

    /**
     * 文章新增
     *
     * @support  string $title 标题 [ require true ]
     * @support  string $label 标签 [ require false ]
     * @support  int $sort 排序 [ require false ]
     * @support  string $nodeType 节点类型 [ require false ]
     * @support  string $nodeContent 节点内容 [ require true ]
     * @support  string $coverType 封面类型 [ require false ]
     * @support  array $coverImages 封面图片 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function addArticle () {
        return self::getClass()->addArticle([
        ]);
    }

    /**
     * 文章编辑
     *
     * @support  int $id 文章id [ require true ]
     * @support  string $title 标题 [ require false ]
     * @support  string $label 标签 [ require false ]
     * @support  int $sort 排序 [ require false ]
     * @support  string $nodeType 节点类型 [ require false ]
     * @support  string $nodeContent 节点内容 [ require false ]
     * @support  string $coverType 封面类型 [ require false ]
     * @support  array $coverImages 封面图片 [ require false ]
     * @support  string $status 状态 [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function editArticle () {
        return self::getClass()->editArticle([
        ]);
    }

    /**
     * 文章详情
     *
     * @support  int $id 文章id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getArticle () {
        return self::getClass()->getArticle([
        ]);
    }

    /**
     * 文章删除
     *
     * @support  int $id 文章id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function deleteArticle () {
        return self::getClass()->deleteArticle([
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoMicroDiscuss', 'HappinessPhotoStudio\Article');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoMicroDiscuss', 'HappinessPhotoStudio\Article');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}