<?php
namespace Mainto\Bridge\Invokes\HimoMicroDiscuss;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method addShareOrdersByParams(array|\Mainto\Bridge\Structs\HimoMicroDiscuss\Cmd\ShareOrder\ShareOrdersCmd $params)
 * @method shareOrderListByParams(array|\Mainto\Bridge\Structs\HimoMicroDiscuss\Cmd\ShareOrder\ShareOrderListCmd $params)
 * @method shareOrderInfoByParams(array $params)
 * @method changeShareOrderStatusByParams(array $params)
 * @method setAfterSaleByParams(array $params)
 * @method setLikeByParams(array $params)
 * @method setTagsByParams(array $params)
 * @method updateShareOrderContentByParams(array|\Mainto\Bridge\Structs\HimoMicroDiscuss\Cmd\ShareOrder\ShareOrderUpdateCmd $params)
 * @method deleteShareOrderByParams(array $params)
 */
class ShareOrders {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 添加晒单数据
     *
     * @var  \Mainto\Bridge\Structs\HimoMicroDiscuss\Cmd\ShareOrder\ShareOrdersCmd $shareOrdersCmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\HimoMicroDiscuss\DTO\ShareOrder\ShareOrderBaseInfoDTO[]
     */
    public static function addShareOrders (\Mainto\Bridge\Structs\HimoMicroDiscuss\Cmd\ShareOrder\ShareOrdersCmd $shareOrdersCmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->addShareOrders($shareOrdersCmd),
            "\Mainto\Bridge\Structs\HimoMicroDiscuss\DTO\ShareOrder\ShareOrderBaseInfoDTO[]"
        );
    }


    /**
     * 晒单列表
     *
     * @var  \Mainto\Bridge\Structs\HimoMicroDiscuss\Cmd\ShareOrder\ShareOrderListCmd $shareOrderListCmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\HimoMicroDiscuss\DTO\ShareOrder\ShareOrderListDTO
     */
    public static function shareOrderList (\Mainto\Bridge\Structs\HimoMicroDiscuss\Cmd\ShareOrder\ShareOrderListCmd $shareOrderListCmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->shareOrderList($shareOrderListCmd),
            "\Mainto\Bridge\Structs\HimoMicroDiscuss\DTO\ShareOrder\ShareOrderListDTO"
        );
    }


    /**
     * 买家秀详情
     *
     * @param  int $shareOrderId 晒单id [ require true ]
     * @param  bool $setPageView 是否增加浏览量 [ require false ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\HimoMicroDiscuss\DTO\ShareOrder\ShareOrderInfoDTO
     */
    public static function shareOrderInfo (int $shareOrderId, bool $setPageView = false) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->shareOrderInfo([
                            "shareOrderId" => $shareOrderId,
                            "setPageView" => $setPageView,
                        ]),
            "\Mainto\Bridge\Structs\HimoMicroDiscuss\DTO\ShareOrder\ShareOrderInfoDTO"
        );
    }

    /**
     * 设置晒单状态
     *
     * @param  int $shareOrderId 晒单id [ require true ]
     * @param  string $status 晒单状态 [ require true ]
     * @param  string $refuseReason 拒绝原因 [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function changeShareOrderStatus (int $shareOrderId, string $status, string $refuseReason = null) {
        return self::getClass()->changeShareOrderStatus([
            "shareOrderId" => $shareOrderId,
            "status" => $status,
            "refuseReason" => $refuseReason,
        ]);
    }

    /**
     * 设置售后
     *
     * @param  int $shareOrderId 晒单id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function setAfterSale (int $shareOrderId) {
        return self::getClass()->setAfterSale([
            "shareOrderId" => $shareOrderId,
        ]);
    }

    /**
     * 设置点赞数据
     *
     * @param  int $shareOrderId 晒单id [ require true ]
     * @param  bool $isLike 是否点赞 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function setLike (int $shareOrderId, bool $isLike) {
        return self::getClass()->setLike([
            "shareOrderId" => $shareOrderId,
            "isLike" => $isLike,
        ]);
    }

    /**
     * 设置晒单标签数据
     *
     * @param  int $shareOrderId 晒单id [ require true ]
     * @param  array $tagIds 标签ids [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function setTags (int $shareOrderId, array $tagIds) {
        return self::getClass()->setTags([
            "shareOrderId" => $shareOrderId,
            "tagIds" => $tagIds,
        ]);
    }

    /**
     * 更新买家秀数据
     *
     * @var  \Mainto\Bridge\Structs\HimoMicroDiscuss\Cmd\ShareOrder\ShareOrderUpdateCmd $shareOrderUpdateCmd
     * @throws  \Exception
     * @return  bool
     */
    public static function updateShareOrderContent (\Mainto\Bridge\Structs\HimoMicroDiscuss\Cmd\ShareOrder\ShareOrderUpdateCmd $shareOrderUpdateCmd) {
        return self::getClass()->updateShareOrderContent($shareOrderUpdateCmd);
    }


    /**
     * 删除买家秀数据
     *
     * @param  int $shareOrderId 买家秀id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function deleteShareOrder (int $shareOrderId) {
        return self::getClass()->deleteShareOrder([
            "shareOrderId" => $shareOrderId,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoMicroDiscuss', 'ShareOrders');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoMicroDiscuss', 'ShareOrders');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}