<?php
namespace Mainto\Bridge\Invokes\HimoMicroDiscuss;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method listArticleCategoryByParams(array|\Mainto\Bridge\Structs\HimoMicroDiscuss\Cmd\ArticleCategory\ArticleCategoryListCmd $params)
 * @method addArticleCategoryByParams(array|\Mainto\Bridge\Structs\HimoMicroDiscuss\Cmd\ArticleCategory\ArticleCategoryAddCmd $params)
 * @method editArticleCategoryByParams(array|\Mainto\Bridge\Structs\HimoMicroDiscuss\Cmd\ArticleCategory\ArticleCategoryEditCmd $params)
 * @method getArticleCategoryByParams(array $params)
 * @method deleteArticleCategoryByParams(array $params)
 */
class ArticleCategory {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 文章类目列表
     *
     * @var  \Mainto\Bridge\Structs\HimoMicroDiscuss\Cmd\ArticleCategory\ArticleCategoryListCmd $articleCategoryListCmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\HimoMicroDiscuss\DTO\ArticleCategory\ArticleCategoryListDTO
     */
    public static function listArticleCategory (\Mainto\Bridge\Structs\HimoMicroDiscuss\Cmd\ArticleCategory\ArticleCategoryListCmd $articleCategoryListCmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->listArticleCategory($articleCategoryListCmd),
            "\Mainto\Bridge\Structs\HimoMicroDiscuss\DTO\ArticleCategory\ArticleCategoryListDTO"
        );
    }


    /**
     * 文章类目新增
     *
     * @var  \Mainto\Bridge\Structs\HimoMicroDiscuss\Cmd\ArticleCategory\ArticleCategoryAddCmd $articleCategoryAddCmd
     * @throws  \Exception
     * @return  bool
     */
    public static function addArticleCategory (\Mainto\Bridge\Structs\HimoMicroDiscuss\Cmd\ArticleCategory\ArticleCategoryAddCmd $articleCategoryAddCmd) {
        return self::getClass()->addArticleCategory($articleCategoryAddCmd);
    }


    /**
     * 文章类目编辑
     *
     * @var  \Mainto\Bridge\Structs\HimoMicroDiscuss\Cmd\ArticleCategory\ArticleCategoryEditCmd $articleCategoryEditCmd
     * @throws  \Exception
     * @return  bool
     */
    public static function editArticleCategory (\Mainto\Bridge\Structs\HimoMicroDiscuss\Cmd\ArticleCategory\ArticleCategoryEditCmd $articleCategoryEditCmd) {
        return self::getClass()->editArticleCategory($articleCategoryEditCmd);
    }


    /**
     * 文章类目详情
     *
     * @param  int $articleCategoryId 文章类目id [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\HimoMicroDiscuss\DTO\ArticleCategory\ArticleCategoryDTO
     */
    public static function getArticleCategory (int $articleCategoryId) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getArticleCategory([
                            "articleCategoryId" => $articleCategoryId,
                        ]),
            "\Mainto\Bridge\Structs\HimoMicroDiscuss\DTO\ArticleCategory\ArticleCategoryDTO"
        );
    }

    /**
     * 文章类目删除
     *
     * @param  int $articleCategoryId 文章类目id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function deleteArticleCategory (int $articleCategoryId) {
        return self::getClass()->deleteArticleCategory([
            "articleCategoryId" => $articleCategoryId,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoMicroDiscuss', 'ArticleCategory');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoMicroDiscuss', 'ArticleCategory');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}