<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2025-06-13 17:25:41
 */
namespace Mainto\Bridge\Invokes\HimoMicroDiscuss;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class ArticleCategory
 * @method listArticleCategoryByParams(array $params) 文章类目列表
 * @method addArticleCategoryByParams(array $params) 文章类目新增
 * @method editArticleCategoryByParams(array $params) 文章类目编辑
 * @method getArticleCategoryByParams(array $params) 文章类目详情
 * @method deleteArticleCategoryByParams(array $params) 文章类目删除
 */
class ArticleCategory {
    private static string $serviceName = "HimoMicroDiscuss";

    private static string $className = "ArticleCategory";

    /**
     * 文章类目列表
     * @return  \Mainto\Bridge\Structs\HimoMicroDiscuss\DTO\ArticleCategory\ArticleCategoryListDTO
    */
    public static function listArticleCategory (?\Mainto\Bridge\Structs\HimoMicroDiscuss\Cmd\ArticleCategory\ArticleCategoryListCmd $articleCategoryListCmd = null) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->listArticleCategory($articleCategoryListCmd),
            "\Mainto\Bridge\Structs\HimoMicroDiscuss\DTO\ArticleCategory\ArticleCategoryListDTO"
        );
    }

    /**
     * 文章类目新增
     * @return  bool
    */
    public static function addArticleCategory (\Mainto\Bridge\Structs\HimoMicroDiscuss\Cmd\ArticleCategory\ArticleCategoryAddCmd $articleCategoryAddCmd) {
        return RpcClass::getClass(self::$serviceName, self::$className)->addArticleCategory($articleCategoryAddCmd);
    }

    /**
     * 文章类目编辑
     * @return  bool
    */
    public static function editArticleCategory (\Mainto\Bridge\Structs\HimoMicroDiscuss\Cmd\ArticleCategory\ArticleCategoryEditCmd $articleCategoryEditCmd) {
        return RpcClass::getClass(self::$serviceName, self::$className)->editArticleCategory($articleCategoryEditCmd);
    }

    /**
     * 文章类目详情
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  \Mainto\Bridge\Structs\HimoMicroDiscuss\DTO\ArticleCategory\ArticleCategoryDTO
    */
    public static function getArticleCategory (int $articleCategoryId) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getArticleCategory(["articleCategoryId" => $articleCategoryId]),
            "\Mainto\Bridge\Structs\HimoMicroDiscuss\DTO\ArticleCategory\ArticleCategoryDTO"
        );
    }

    /**
     * 文章类目删除
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function deleteArticleCategory (int $articleCategoryId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->deleteArticleCategory(["articleCategoryId" => $articleCategoryId]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}