<?php
namespace Mainto\Bridge\Invokes\HimoMicroDiscuss;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method listCityArticleByParams(array|\Mainto\Bridge\Structs\HimoMicroDiscuss\Cmd\CityArticle\CityArticleListCmd $params)
 * @method addCityArticleByParams(array|\Mainto\Bridge\Structs\HimoMicroDiscuss\Cmd\CityArticle\CityArticleAddCmd $params)
 * @method editCityArticleByParams(array|\Mainto\Bridge\Structs\HimoMicroDiscuss\Cmd\CityArticle\CityArticleEditCmd $params)
 * @method getCityArticleByParams(array $params)
 * @method deleteCityArticleByParams(array $params)
 */
class CityArticle {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 城市文章列表
     *
     * @var  \Mainto\Bridge\Structs\HimoMicroDiscuss\Cmd\CityArticle\CityArticleListCmd $cityArticleListCmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\HimoMicroDiscuss\DTO\CityArticle\CityArticleListDTO
     */
    public static function listCityArticle (\Mainto\Bridge\Structs\HimoMicroDiscuss\Cmd\CityArticle\CityArticleListCmd $cityArticleListCmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->listCityArticle($cityArticleListCmd),
            "\Mainto\Bridge\Structs\HimoMicroDiscuss\DTO\CityArticle\CityArticleListDTO"
        );
    }


    /**
     * 城市文章新增
     *
     * @var  \Mainto\Bridge\Structs\HimoMicroDiscuss\Cmd\CityArticle\CityArticleAddCmd $cityArticleAddCmd
     * @throws  \Exception
     * @return  bool
     */
    public static function addCityArticle (\Mainto\Bridge\Structs\HimoMicroDiscuss\Cmd\CityArticle\CityArticleAddCmd $cityArticleAddCmd) {
        return self::getClass()->addCityArticle($cityArticleAddCmd);
    }


    /**
     * 城市文章编辑
     *
     * @var  \Mainto\Bridge\Structs\HimoMicroDiscuss\Cmd\CityArticle\CityArticleEditCmd $cityArticleEditCmd
     * @throws  \Exception
     * @return  bool
     */
    public static function editCityArticle (\Mainto\Bridge\Structs\HimoMicroDiscuss\Cmd\CityArticle\CityArticleEditCmd $cityArticleEditCmd) {
        return self::getClass()->editCityArticle($cityArticleEditCmd);
    }


    /**
     * 城市文章详情
     *
     * @param  int $cityArticleId 城市文章id [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\HimoMicroDiscuss\DTO\CityArticle\CityArticleDTO
     */
    public static function getCityArticle (int $cityArticleId) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getCityArticle([
                            "cityArticleId" => $cityArticleId,
                        ]),
            "\Mainto\Bridge\Structs\HimoMicroDiscuss\DTO\CityArticle\CityArticleDTO"
        );
    }

    /**
     * 城市文章删除
     *
     * @param  int $cityArticleId 城市文章id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function deleteCityArticle (int $cityArticleId) {
        return self::getClass()->deleteCityArticle([
            "cityArticleId" => $cityArticleId,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoMicroDiscuss', 'CityArticle');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoMicroDiscuss', 'CityArticle');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}