<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-02-17 10:29:52
 */
namespace Mainto\Bridge\Structs\HimoMicroDiscuss\Cmd\ShareOrder;

class ShareOrderCmd {
    /**
     * @var  int
     * 用户id
     * validation: 
     */
    public int $userId;
    /**
     * @var  string
     * 用户手机号
     * validation: 
     */
    public string $phone;
    /**
     * @var  string
     * 订单号
     * validation: 
     */
    public string $orderNum;
    /**
     * @var  int
     * 评分
     * validation: 
     */
    public int $starLevel;
    /**
     * @var  string
     * 评论标题
     * validation: 
     */
    public string $commentTitle = "";
    /**
     * @var  string
     * 评论
     * validation: 
     */
    public string $comment = "";
    /**
     * @var  int
     * 发起人
     * validation: 
     */
    public int $promoter = 0;
    /**
     * @var  int
     * 初始化页面浏览量
     * validation: 
     */
    public int $initPageView = 0;
    /**
     * @var  string
     * 发起人类型 ShareOrderPromoterTypeEnum
     * validation: ShareOrderPromoterType
     */
    public string $promoterType = "user";
    /**
     * @var  string
     * 状态 1、待授权:unauthorized 2、待审核 un_audit
     * validation: in:unauthorized,un_audit
     */
    public string $status;
    /**
     * @var  int
     * 是否转接售后
     * validation: 
     */
    public int $isSaleAfter = 0;
    /**
     * @var  int
     * 排序
     * validation: 
     */
    public int $sort = 0;
    /**
     * @var  string
     * 品牌 1、海马体 himo 2、海马体家庭 family 3、缦图mantu
     * validation: in:himo,family,mantu
     */
    public string $brand;
    /**
     * @var  string
     * 发布平台
     * validation: sometimes|PromoterPlatform
     */
    public string $promoterPlatform = "";
    /**
     * @var  int
     * 订单所在门店的城市id
     * validation: 
     */
    public int $cityId = 0;
    /**
     * @var  \Mainto\Bridge\Structs\HimoMicroDiscuss\Cmd\ShareOrder\ShareOrderProductCmd[]
     * 晒单产品信息
     * validation: 
     */
    public array $products = [];
    /**
     * @var  int[]
     * 买家秀标签
     * validation: 
     */
    public array $tags = [];
    /**
     * @var  \Mainto\Bridge\Structs\HimoMicroDiscuss\Cmd\ShareOrder\ShareOrderTopicCmd[]
     * 买家秀话题
     * validation: 
     */
    public array $topics = [];
    /**
     * @var  null|\Mainto\Bridge\Structs\HimoMicroDiscuss\Cmd\ShareOrder\ShareOrderExtendCmd
     * 买家秀扩展信息
     * validation: 
     */
    public ?\Mainto\Bridge\Structs\HimoMicroDiscuss\Cmd\ShareOrder\ShareOrderExtendCmd $extend = null;
    /**
     * @var  null|string
     * 预约端提交时间：用户每次提交都更新, 需要用户端自己传值
     * validation: 
     */
    public ?string $userUpdatedAt = null;
    /**
     * @var  bool
     * 是否同步圈圈
     * validation: 
     */
    public bool $isSynchronousCommunity = false;

    public function __construct (int $userId = 0, string $phone = '', string $orderNum = '', int $starLevel = 0, string $status = '', string $brand = '') {
        $this->userId = $userId;
        $this->phone = $phone;
        $this->orderNum = $orderNum;
        $this->starLevel = $starLevel;
        $this->status = $status;
        $this->brand = $brand;
    }

    public static function create(int $userId = 0, string $phone = '', string $orderNum = '', int $starLevel = 0, string $status = '', string $brand = ''): self {
        return new self($userId, $phone, $orderNum, $starLevel, $status, $brand);
    }

    public function setUserId(int $userId): self {
        $this->userId = $userId;

        return $this;
    }

    public function setPhone(string $phone): self {
        $this->phone = $phone;

        return $this;
    }

    public function setOrderNum(string $orderNum): self {
        $this->orderNum = $orderNum;

        return $this;
    }

    public function setStarLevel(int $starLevel): self {
        $this->starLevel = $starLevel;

        return $this;
    }

    public function setCommentTitle(string $commentTitle): self {
        $this->commentTitle = $commentTitle;

        return $this;
    }

    public function setComment(string $comment): self {
        $this->comment = $comment;

        return $this;
    }

    public function setPromoter(int $promoter): self {
        $this->promoter = $promoter;

        return $this;
    }

    public function setInitPageView(int $initPageView): self {
        $this->initPageView = $initPageView;

        return $this;
    }

    public function setPromoterType(string $promoterType): self {
        $this->promoterType = $promoterType;

        return $this;
    }

    public function setStatus(string $status): self {
        $this->status = $status;

        return $this;
    }

    public function setIsSaleAfter(int $isSaleAfter): self {
        $this->isSaleAfter = $isSaleAfter;

        return $this;
    }

    public function setSort(int $sort): self {
        $this->sort = $sort;

        return $this;
    }

    public function setBrand(string $brand): self {
        $this->brand = $brand;

        return $this;
    }

    public function setPromoterPlatform(string $promoterPlatform): self {
        $this->promoterPlatform = $promoterPlatform;

        return $this;
    }

    public function setCityId(int $cityId): self {
        $this->cityId = $cityId;

        return $this;
    }

    public function setProducts(array $products): self {
        $this->products = $products;

        return $this;
    }

    public function setTags(array $tags): self {
        $this->tags = $tags;

        return $this;
    }

    public function setTopics(array $topics): self {
        $this->topics = $topics;

        return $this;
    }

    public function setExtend(?\Mainto\Bridge\Structs\HimoMicroDiscuss\Cmd\ShareOrder\ShareOrderExtendCmd $extend): self {
        $this->extend = $extend;

        return $this;
    }

    public function setUserUpdatedAt(?string $userUpdatedAt): self {
        $this->userUpdatedAt = $userUpdatedAt;

        return $this;
    }

    public function setIsSynchronousCommunity(bool $isSynchronousCommunity): self {
        $this->isSynchronousCommunity = $isSynchronousCommunity;

        return $this;
    }
}