<?php
namespace Mainto\Bridge\Invokes\HimoMicroDiscuss;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method listArticleCategoryByParams(array|ArticleCategory\ListArticleCategory\ArticleCategoryListCmd $params)
 * @method addArticleCategoryByParams(array|ArticleCategory\AddArticleCategory\ArticleCategoryAddCmd $params)
 * @method editArticleCategoryByParams(array|ArticleCategory\EditArticleCategory\ArticleCategoryEditCmd $params)
 * @method getArticleCategoryByParams(array $params)
 * @method deleteArticleCategoryByParams(array $params)
 */
class ArticleCategory {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 文章类目列表
     *
     * @var  ArticleCategory\ListArticleCategory\ArticleCategoryListCmd $articleCategoryListCmd $articleCategoryListCmd
     * @throws  \Exception
     * @return  ArticleCategory\ListArticleCategory\ArticleCategoryListDTO
     */
    public static function listArticleCategory (ArticleCategory\ListArticleCategory\ArticleCategoryListCmd $articleCategoryListCmd) {
        return RpcDefinition::getInstance()->getMapper()->mapUseTypeString(
            self::getClass()->listArticleCategory($articleCategoryListCmd),
            "\Mainto\Bridge\Invokes\HimoMicroDiscuss\ArticleCategory\ListArticleCategory\ArticleCategoryListDTO"
        );
    }


    /**
     * 文章类目新增
     *
     * @var  ArticleCategory\AddArticleCategory\ArticleCategoryAddCmd $articleCategoryAddCmd $articleCategoryAddCmd
     * @throws  \Exception
     * @return  bool
     */
    public static function addArticleCategory (ArticleCategory\AddArticleCategory\ArticleCategoryAddCmd $articleCategoryAddCmd) {
        return self::getClass()->addArticleCategory($articleCategoryAddCmd);
    }


    /**
     * 文章类目编辑
     *
     * @var  ArticleCategory\EditArticleCategory\ArticleCategoryEditCmd $articleCategoryEditCmd $articleCategoryEditCmd
     * @throws  \Exception
     * @return  bool
     */
    public static function editArticleCategory (ArticleCategory\EditArticleCategory\ArticleCategoryEditCmd $articleCategoryEditCmd) {
        return self::getClass()->editArticleCategory($articleCategoryEditCmd);
    }


    /**
     * 文章类目详情
     *
     * @param  int $articleCategoryId 文章类目id [ require true ]
     * @throws  \Exception
     * @return  ArticleCategory\GetArticleCategory\ArticleCategoryDTO
     */
    public static function getArticleCategory (int $articleCategoryId) {
        return RpcDefinition::getInstance()->getMapper()->mapUseTypeString(
            self::getClass()->getArticleCategory([
                            "articleCategoryId" => $articleCategoryId,
                        ]),
            "\Mainto\Bridge\Invokes\HimoMicroDiscuss\ArticleCategory\GetArticleCategory\ArticleCategoryDTO"
        );
    }

    /**
     * 文章类目删除
     *
     * @param  int $articleCategoryId 文章类目id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function deleteArticleCategory (int $articleCategoryId) {
        return self::getClass()->deleteArticleCategory([
            "articleCategoryId" => $articleCategoryId,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoMicroDiscuss', 'ArticleCategory');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoMicroDiscuss', 'ArticleCategory');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}