<?php
namespace Mainto\Bridge\Invokes\HimoMicroDiscuss;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method listCityArticleByParams(array|CityArticle\ListCityArticle\CityArticleListCmd $params)
 * @method addCityArticleByParams(array|CityArticle\AddCityArticle\CityArticleAddCmd $params)
 * @method editCityArticleByParams(array|CityArticle\EditCityArticle\CityArticleEditCmd $params)
 * @method getCityArticleByParams(array $params)
 * @method deleteCityArticleByParams(array $params)
 */
class CityArticle {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 城市文章列表
     *
     * @var  CityArticle\ListCityArticle\CityArticleListCmd $cityArticleListCmd $cityArticleListCmd
     * @throws  \Exception
     * @return  mixed
     */
    public static function listCityArticle (CityArticle\ListCityArticle\CityArticleListCmd $cityArticleListCmd) {
        return self::getClass()->listCityArticle($cityArticleListCmd);
    }


    /**
     * 城市文章新增
     *
     * @var  CityArticle\AddCityArticle\CityArticleAddCmd $cityArticleAddCmd $cityArticleAddCmd
     * @throws  \Exception
     * @return  bool
     */
    public static function addCityArticle (CityArticle\AddCityArticle\CityArticleAddCmd $cityArticleAddCmd) {
        return self::getClass()->addCityArticle($cityArticleAddCmd);
    }


    /**
     * 城市文章编辑
     *
     * @var  CityArticle\EditCityArticle\CityArticleEditCmd $cityArticleEditCmd $cityArticleEditCmd
     * @throws  \Exception
     * @return  bool
     */
    public static function editCityArticle (CityArticle\EditCityArticle\CityArticleEditCmd $cityArticleEditCmd) {
        return self::getClass()->editCityArticle($cityArticleEditCmd);
    }


    /**
     * 城市文章详情
     *
     * @param  int $cityArticleId 城市文章id [ require true ]
     * @throws  \Exception
     * @return  CityArticle\GetCityArticle\CityArticleDTO
     */
    public static function getCityArticle (int $cityArticleId) {
        return RpcDefinition::getInstance()->getMapper()->mapUseTypeString(
            self::getClass()->getCityArticle([
                            "cityArticleId" => $cityArticleId,
                        ]),
            "\Mainto\Bridge\Invokes\HimoMicroDiscuss\CityArticle\GetCityArticle\CityArticleDTO"
        );
    }

    /**
     * 城市文章删除
     *
     * @param  int $cityArticleId 城市文章id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function deleteCityArticle (int $cityArticleId) {
        return self::getClass()->deleteCityArticle([
            "cityArticleId" => $cityArticleId,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoMicroDiscuss', 'CityArticle');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoMicroDiscuss', 'CityArticle');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}