<?php
namespace Mainto\Bridge\Invokes\HimoMicroDiscuss\HappinessPhotoStudio;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method addArticleByParams(array $params)
 */
class Article {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 文章新增
     *
     * @support  string $title 标题 [ require true ]
     * @support  string $label 标签 [ require true ]
     * @support  int $sort 排序 
     * @support  string $nodeType 节点类型 [ require true ]
     * @support  string $nodeContent 节点内容 [ require true ]
     * @support  string $coverType 封面类型 [ require true ]
     * @support  array $coverImages 封面图片 
     * @throws  \Exception
     * @return  mixed
     */
    public static function addArticle () {
        return self::getClass()->addArticle();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoMicroDiscuss', 'HappinessPhotoStudio\Article');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoMicroDiscuss', 'HappinessPhotoStudio\Article');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}