<?php
namespace Mainto\Bridge\Invokes\HimoMicroDiscuss;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method addShareOrdersByParams(array $params)
 * @method shareOrderListByParams(array $params)
 * @method listByParams(array $params)
 * @method setStarByParams(array $params)
 * @method getShareOrderByIdByParams(array $params)
 * @method deleteShareOrderByParams(array $params)
 * @method setAfterSaleByParams(array $params)
 */
class ShareOrder {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 添加晒单数据内容
     *
     * @support  array $shareOrders 晒单数据 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function addShareOrders () {
        return self::getClass()->addShareOrders();
    }

    /**
     * 晒单列表
     *
     * @support  int $page 当前页 
     * @support  int $pageSize 页内条数 
     * @support  int $isStar 获取精选晒单 
     * @support  int $categoryId 类目id 
     * @support  string $orderNum 订单编号 
     * @support  int $userId 用户Id 
     * @support  string $phone 手机号 
     * @support  array $orderNums 订单编号数组 
     * @support  array $categoryIds 类目id数组 
     * @throws  \Exception
     * @return  array
     */
    public static function shareOrderList () {
        return self::getClass()->shareOrderList();
    }

    /**
     * 管理端-晒单列表
     *
     * @support  string $start_time 提交日期开始时间 
     * @support  string $end_time 提交日期结束时间 
     * @support  int $star_level 星级 
     * @support  string $order_num 订单号 
     * @support  string $phone 手机号查询 
     * @support  int $is_star 是否是精选 
     * @support  int $is_sale_after 是否转接售后 
     * @support  string $keyword 关键词 
     * @support  int $page 页码 [Original type uint] 
     * @support  int $page_size 条数 [Original type uint] 
     * @throws  \Exception
     * @return  array
     */
    public static function list () {
        return self::getClass()->list();
    }

    /**
     * 设置精选晒单
     *
     * @support  int $id 晒单id [ require true ]
     * @support  int $is_star 是否是精选1:是 0:不是 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function setStar () {
        return self::getClass()->setStar();
    }

    /**
     * 根据id获取用户晒单
     *
     * @support  int $id 晒单id 
     * @throws  \Exception
     * @return  array
     */
    public static function getShareOrderById () {
        return self::getClass()->getShareOrderById();
    }

    /**
     * 删除用户晒单
     *
     * @support  int $id 晒单id 
     * @throws  \Exception
     * @return  mixed
     */
    public static function deleteShareOrder () {
        return self::getClass()->deleteShareOrder();
    }

    /**
     * 设置售后
     *
     * @support  int $id 晒单id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function setAfterSale () {
        return self::getClass()->setAfterSale();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoMicroDiscuss', 'ShareOrder');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoMicroDiscuss', 'ShareOrder');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}