<?php
namespace Mainto\Bridge\Invokes\HimoMicroDiscuss;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method addShareOrdersByParams(array $params)
 * @method shareOrderListByParams(array $params)
 * @method setStarShareOrderByParams(array $params)
 * @method getShareOrderByIdByParams(array $params)
 * @method deleteShareOrderByParams(array $params)
 */
class ShareOrder {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 添加晒单数据内容
     *
     * @support  array $shareOrders 晒单数据 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function addShareOrders () {
        return self::getClass()->addShareOrders();
    }

    /**
     * 晒单列表
     *
     * @support  int $page 当前页 
     * @support  int $pageSize 页内条数 
     * @support  int $isStar 获取精选晒单 
     * @support  int $categoryId 类目id 
     * @support  string $orderNum 订单编号 
     * @support  int $userId 用户Id 
     * @support  string $phone 手机号 
     * @support  array $orderNums 订单编号数组 
     * @throws  \Exception
     * @return  array
     */
    public static function shareOrderList () {
        return self::getClass()->shareOrderList();
    }

    /**
     * 设置精选晒单
     *
     * @support  int $id 晒单id 
     * @throws  \Exception
     * @return  mixed
     */
    public static function setStarShareOrder () {
        return self::getClass()->setStarShareOrder();
    }

    /**
     * 根据id获取用户晒单
     *
     * @support  int $id 晒单id 
     * @throws  \Exception
     * @return  mixed
     */
    public static function getShareOrderById () {
        return self::getClass()->getShareOrderById();
    }

    /**
     * 删除用户晒单
     *
     * @support  int $id 晒单id 
     * @throws  \Exception
     * @return  mixed
     */
    public static function deleteShareOrder () {
        return self::getClass()->deleteShareOrder();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoMicroDiscuss', 'ShareOrder');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoMicroDiscuss', 'ShareOrder');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}