<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2025-03-04 15:28:20
 */
namespace Mainto\Bridge\Structs\HimoKms\KMS\DTO;

class WechatMicroAppAccessTokenDTO {
    /**
     * @var  string
     * 微信小程序的全局唯一调用凭据
     * validation: 
     */
    public string $accessToken;
    /**
     * @var  int
     * 调用凭据的有效期
     * validation: 
     */
    public int $expireTime;
    /**
     * @var  bool
     * 本次请求是否成功，true = 成功，false = 失败
     * validation: 
     */
    public bool $isSucceed = true;
    /**
     * @var  string
     * 错误消息，isSucceed = true时，该字段为空字符串
     * validation: 
     */
    public string $errMsg = "";

    public function __construct (string $accessToken = '', int $expireTime = 0) {
        if (!is_null($accessToken)) {
            $this->accessToken = $accessToken;
        }
        if (!is_null($expireTime)) {
            $this->expireTime = $expireTime;
        }
    }

    public static function create(string $accessToken = '', int $expireTime = 0): self {
        return new self($accessToken, $expireTime);
    }

    public function setAccessToken(string $accessToken): self {
        $this->accessToken = $accessToken;

        return $this;
    }

    public function setExpireTime(int $expireTime): self {
        $this->expireTime = $expireTime;

        return $this;
    }

    public function setIsSucceed(bool $isSucceed): self {
        $this->isSucceed = $isSucceed;

        return $this;
    }

    public function setErrMsg(string $errMsg): self {
        $this->errMsg = $errMsg;

        return $this;
    }
}