<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-09-12 08:28:23
 */
namespace Mainto\Bridge\Invokes\HimoKms\KMS;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class KMS
 * @method createByParams(array $params) 创建新Key
 * @method updateByParams(array $params) 更新指定的Key
 * @method getDingtalkAppPasswordDTOByParams(array $params) 获取钉钉开放平台 AccessToken
 * @method getBytedanceAppAccessTokenDTOByParams(array $params) 获取字节小程序 AccessToken
 * @method getDingtalkAppConfigDTOByParams(array $params) 获取钉钉开发者配置信息
 * @method getAlipayAppConfigDTOByParams(array $params) 获取支付宝开发者配置信息
 * @method getBytedanceAppConfigDTOByParams(array $params) 获取字节小程序开发者配置信息
 * @method getWechatMicroAppAccessTokenByParams(array $params) 获取微信小程序AccessToken
 * @method getBytedanceAppSignByParams(array $params) 获取抖音签名
 */
class KMS {
    private static string $serviceName = "HimoKms";

    private static string $className = "KMS\\KMS";

    /**
     * 创建新Key
     * @return  \Mainto\Bridge\Structs\HimoKms\KMS\DTO\KeyDTO
    */
    public static function create (\Mainto\Bridge\Structs\HimoKms\KMS\Cmd\StoreCmd $storeCmd) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->create($storeCmd),
            "\Mainto\Bridge\Structs\HimoKms\KMS\DTO\KeyDTO"
        );
    }

    /**
     * 更新指定的Key
     * @return  \Mainto\Bridge\Structs\HimoKms\KMS\DTO\KeyDTO
    */
    public static function update (\Mainto\Bridge\Structs\HimoKms\KMS\Cmd\StoreCmd $storeCmd) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->update($storeCmd),
            "\Mainto\Bridge\Structs\HimoKms\KMS\DTO\KeyDTO"
        );
    }

    /**
     * 获取钉钉开放平台 AccessToken
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  \Mainto\Bridge\Structs\HimoKms\KMS\DTO\DingtalkAppPasswordDTO
    */
    public static function getDingtalkAppPasswordDTO (string $keyName, bool $refresh = false) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getDingtalkAppPasswordDTO(["keyName" => $keyName, "refresh" => $refresh]),
            "\Mainto\Bridge\Structs\HimoKms\KMS\DTO\DingtalkAppPasswordDTO"
        );
    }

    /**
     * 获取字节小程序 AccessToken
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  \Mainto\Bridge\Structs\HimoKms\KMS\DTO\BytedanceAppPasswordDTO
    */
    public static function getBytedanceAppAccessTokenDTO (string $keyName, bool $refresh = false) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getBytedanceAppAccessTokenDTO(["keyName" => $keyName, "refresh" => $refresh]),
            "\Mainto\Bridge\Structs\HimoKms\KMS\DTO\BytedanceAppPasswordDTO"
        );
    }

    /**
     * 获取钉钉开发者配置信息
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  \Mainto\Bridge\Structs\HimoKms\KMS\DTO\DingtalkAppConfigDTO
    */
    public static function getDingtalkAppConfigDTO (string $keyName) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getDingtalkAppConfigDTO(["keyName" => $keyName]),
            "\Mainto\Bridge\Structs\HimoKms\KMS\DTO\DingtalkAppConfigDTO"
        );
    }

    /**
     * 获取支付宝开发者配置信息
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  \Mainto\Bridge\Structs\HimoKms\KMS\DTO\AlipayAppConfigDTO
    */
    public static function getAlipayAppConfigDTO (string $keyName) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getAlipayAppConfigDTO(["keyName" => $keyName]),
            "\Mainto\Bridge\Structs\HimoKms\KMS\DTO\AlipayAppConfigDTO"
        );
    }

    /**
     * 获取字节小程序开发者配置信息
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  \Mainto\Bridge\Structs\HimoKms\KMS\DTO\BytedanceAppConfigDTO
    */
    public static function getBytedanceAppConfigDTO (string $keyName) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getBytedanceAppConfigDTO(["keyName" => $keyName]),
            "\Mainto\Bridge\Structs\HimoKms\KMS\DTO\BytedanceAppConfigDTO"
        );
    }

    /**
     * 获取微信小程序AccessToken
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  \Mainto\Bridge\Structs\HimoKms\KMS\DTO\WechatMicroAppAccessTokenDTO
    */
    public static function getWechatMicroAppAccessToken (string $keyName, bool $refresh = false) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getWechatMicroAppAccessToken(["keyName" => $keyName, "refresh" => $refresh]),
            "\Mainto\Bridge\Structs\HimoKms\KMS\DTO\WechatMicroAppAccessTokenDTO"
        );
    }

    /**
     * 获取抖音签名
     * @return  string
    */
    public static function getBytedanceAppSign (\Mainto\Bridge\Structs\HimoKms\KMS\Cmd\BytedanceAppSignGenCmd $bytedanceAppSignGenCmd) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getBytedanceAppSign($bytedanceAppSignGenCmd);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}