<?php
namespace Mainto\Bridge\Invokes\HimoKms\KMS;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array|\Mainto\Bridge\Structs\HimoKms\KMS\Cmd\StoreCmd $params)
 * @method updateByParams(array|\Mainto\Bridge\Structs\HimoKms\KMS\Cmd\StoreCmd $params)
 * @method getDingtalkAppPasswordDTOByParams(array $params)
 * @method getBytedanceAppAccessTokenDTOByParams(array $params)
 * @method getDingtalkAppConfigDTOByParams(array $params)
 * @method getAlipayAppConfigDTOByParams(array $params)
 */
class KMS {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * create
     *
     * @var  \Mainto\Bridge\Structs\HimoKms\KMS\Cmd\StoreCmd $cmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\HimoKms\KMS\DTO\KeyDTO
     */
    public static function create (\Mainto\Bridge\Structs\HimoKms\KMS\Cmd\StoreCmd $cmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->create($cmd),
            "\Mainto\Bridge\Structs\HimoKms\KMS\DTO\KeyDTO"
        );
    }


    /**
     * update
     *
     * @var  \Mainto\Bridge\Structs\HimoKms\KMS\Cmd\StoreCmd $cmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\HimoKms\KMS\DTO\KeyDTO
     */
    public static function update (\Mainto\Bridge\Structs\HimoKms\KMS\Cmd\StoreCmd $cmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->update($cmd),
            "\Mainto\Bridge\Structs\HimoKms\KMS\DTO\KeyDTO"
        );
    }


    /**
     * getDingtalkAppPasswordDTO
     *
     * @param  string $keyName key name [ require true ]
     * @param  bool $refresh 强制刷新缓存 [ require false ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\HimoKms\KMS\DTO\DingtalkAppPasswordDTO
     */
    public static function getDingtalkAppPasswordDTO (string $keyName, bool $refresh = false) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getDingtalkAppPasswordDTO([
                            "keyName" => $keyName,
                            "refresh" => $refresh,
                        ]),
            "\Mainto\Bridge\Structs\HimoKms\KMS\DTO\DingtalkAppPasswordDTO"
        );
    }

    /**
     * 获取字节小程序 AccessToken
     *
     * @param  string $keyName key name [ require true ]
     * @param  bool $refresh 强制刷新缓存 [ require false ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\HimoKms\KMS\DTO\BytedanceAppPasswordDTO
     */
    public static function getBytedanceAppAccessTokenDTO (string $keyName, bool $refresh = false) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getBytedanceAppAccessTokenDTO([
                            "keyName" => $keyName,
                            "refresh" => $refresh,
                        ]),
            "\Mainto\Bridge\Structs\HimoKms\KMS\DTO\BytedanceAppPasswordDTO"
        );
    }

    /**
     * getDingtalkAppConfigDTO
     *
     * @param  string $keyName key name [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\HimoKms\KMS\DTO\DingtalkAppConfigDTO
     */
    public static function getDingtalkAppConfigDTO (string $keyName) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getDingtalkAppConfigDTO([
                            "keyName" => $keyName,
                        ]),
            "\Mainto\Bridge\Structs\HimoKms\KMS\DTO\DingtalkAppConfigDTO"
        );
    }

    /**
     * getAlipayAppConfigDTO
     *
     * @param  string $keyName key name [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\HimoKms\KMS\DTO\AlipayAppConfigDTO
     */
    public static function getAlipayAppConfigDTO (string $keyName) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getAlipayAppConfigDTO([
                            "keyName" => $keyName,
                        ]),
            "\Mainto\Bridge\Structs\HimoKms\KMS\DTO\AlipayAppConfigDTO"
        );
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoKms', 'KMS\KMS');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoKms', 'KMS\KMS');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}