<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2025-03-09 18:08:03
 */
namespace Mainto\Bridge\Invokes\HimoEbsV2\Tool;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Staff
 * @method syncStaffToGaiaByParams(array $params) 同步指定员工到gaia
 * @method syncStaffUpdatePhoneByParams(array $params) 同步伙伴手机号变更
 * @method syncStaffEventByParams(array $params) 同步指定员工事件到指定服务或第三方
 * @method batchCreateNasStaffByParams(array $params) 批量创建NAS账号
 * @method batchDeleteNasStaffByParams(array $params) 批量删除NAS账号
 * @method batchLeaveByParams(array $params) 批量离职
 * @method batchCreateByParams(array $params) 批量入职
 * @method batchUpdateByParams(array $params) 批量更新
 * @method restoreStaffDepartmentsByParams(array $params) 重新绑定人员部门关系
 * @method batchCreateOvoparkStaffByParams(array $params) 添加万店掌用户表
 * @method syncStaffCreateByParams(array $params) 添加人员到测试企业
 * @method maycurDepartmentByParams(array $params) 同步每刻人员
 * @method deleteDepartmentStaffByIdsByParams(array $params) 处理无效的多部门数据
 * @method saveOrUpdateDepartmentStaffByParams(array $params) 清洗departmentStaff数据
 */
class Staff {
    private static string $serviceName = "HimoEbsV2";

    private static string $className = "Tool\\Staff";

    /**
     * 同步指定员工到gaia
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function syncStaffToGaia (array $staffIds) {
        return RpcClass::getClass(self::$serviceName, self::$className)->syncStaffToGaia(["staffIds" => $staffIds]);
    }

    /**
     * 同步伙伴手机号变更
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function syncStaffUpdatePhone (int $staffId, string $newPhone) {
        return RpcClass::getClass(self::$serviceName, self::$className)->syncStaffUpdatePhone(["staffId" => $staffId, "newPhone" => $newPhone]);
    }

    /**
     * 同步指定员工事件到指定服务或第三方
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function syncStaffEvent (int $staffId, string $action = 'create', array $services = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->syncStaffEvent(["staffId" => $staffId, "action" => $action, "services" => $services]);
    }

    /**
     * 批量创建NAS账号
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function batchCreateNasStaff (array $staffIds) {
        return RpcClass::getClass(self::$serviceName, self::$className)->batchCreateNasStaff(["staffIds" => $staffIds]);
    }

    /**
     * 批量删除NAS账号
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function batchDeleteNasStaff (array $staffIds) {
        return RpcClass::getClass(self::$serviceName, self::$className)->batchDeleteNasStaff(["staffIds" => $staffIds]);
    }

    /**
     * 批量离职
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function batchLeave (array $staffIds) {
        return RpcClass::getClass(self::$serviceName, self::$className)->batchLeave(["staffIds" => $staffIds]);
    }

    /**
     * 批量入职
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function batchCreate (array $staffIds) {
        return RpcClass::getClass(self::$serviceName, self::$className)->batchCreate(["staffIds" => $staffIds]);
    }

    /**
     * 批量更新
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function batchUpdate (array $staffIds) {
        return RpcClass::getClass(self::$serviceName, self::$className)->batchUpdate(["staffIds" => $staffIds]);
    }

    /**
     * 重新绑定人员部门关系
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function restoreStaffDepartments (int $staffId, int $departmentId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->restoreStaffDepartments(["staffId" => $staffId, "departmentId" => $departmentId]);
    }

    /**
     * 添加万店掌用户表
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function batchCreateOvoparkStaff (int $staffId, int $userId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->batchCreateOvoparkStaff(["staffId" => $staffId, "userId" => $userId]);
    }

    /**
     * 添加人员到测试企业
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function syncStaffCreate (int $staffId, string $phone, string $name, string $nickname, int $departmentId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->syncStaffCreate(["staffId" => $staffId, "phone" => $phone, "name" => $name, "nickname" => $nickname, "departmentId" => $departmentId]);
    }

    /**
     * 同步每刻人员
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function maycurDepartment (array $staffIds) {
        return RpcClass::getClass(self::$serviceName, self::$className)->maycurDepartment(["staffIds" => $staffIds]);
    }

    /**
     * 处理无效的多部门数据
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function deleteDepartmentStaffByIds (array $ids) {
        return RpcClass::getClass(self::$serviceName, self::$className)->deleteDepartmentStaffByIds(["ids" => $ids]);
    }

    /**
     * 清洗departmentStaff数据
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function saveOrUpdateDepartmentStaff (array $data) {
        return RpcClass::getClass(self::$serviceName, self::$className)->saveOrUpdateDepartmentStaff(["data" => $data]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}