<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-07-25 11:33:50
 */
namespace Mainto\Bridge\Invokes\HimoEbsV2\Tool;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Department
 * @method syncDepartmentEventByParams(array $params) 同步指定部门事件到指定服务或第三方
 * @method sscUpdateByParams(array $params) 同步ssc
 * @method sscUpdateAllByParams(array $params) 同步属于ssc的所有门店部门
 * @method multiUpdateByParams(array $params) 同步多店管理
 * @method maycurDepartmentByParams(array $params) 同步每刻部门
 */
class Department {
    private static string $serviceName = "HimoEbsV2";

    private static string $className = "Tool\\Department";

    /**
     * 同步指定部门事件到指定服务或第三方
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function syncDepartmentEvent (int $departmentId, string $action = 'create', array $services = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->syncDepartmentEvent(["departmentId" => $departmentId, "action" => $action, "services" => $services]);
    }

    /**
     * 同步ssc
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function sscUpdate (int $departmentId, int $ssc) {
        return RpcClass::getClass(self::$serviceName, self::$className)->sscUpdate(["departmentId" => $departmentId, "ssc" => $ssc]);
    }

    /**
     * 同步属于ssc的所有门店部门
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  int
    */
    public static function sscUpdateAll (int $ssc) {
        return RpcClass::getClass(self::$serviceName, self::$className)->sscUpdateAll(["ssc" => $ssc]);
    }

    /**
     * 同步多店管理
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function multiUpdate (array $staffIds) {
        return RpcClass::getClass(self::$serviceName, self::$className)->multiUpdate(["staffIds" => $staffIds]);
    }

    /**
     * 同步每刻部门
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function maycurDepartment (array $departmentIds) {
        return RpcClass::getClass(self::$serviceName, self::$className)->maycurDepartment(["departmentIds" => $departmentIds]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}