<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-04-25 17:30:04
 */
namespace Mainto\Bridge\Invokes\HimoEbsV2\Inside;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Staff
 * @method getDaysByStaffIdsByParams(array $params) 根据工号获取伙伴周年和生日信息
 * @method getSchedulesByParams(array $params) 根据部门id获取排班信息
 * @method getAttendancesByParams(array $params) 根据部门id获取考勤信息
 * @method getLeaveListByParams(array $params) 批量获取请假信息
 * @method hasAnniversaryCardByParams(array $params) 是否可以领取光年卡
 */
class Staff {
    private static string $serviceName = "HimoEbsV2";

    private static string $className = "Inside\\Staff";

    /**
     * 根据工号获取伙伴周年和生日信息
     * @return  array
    */
    public static function getDaysByStaffIds (array $staffIds) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getDaysByStaffIds(["staffIds" => $staffIds]);
    }
    /**
     * 根据部门id获取排班信息
     * @return  array
    */
    public static function getSchedules (int $departmentId, string $startDate, string $endDate) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getSchedules(["departmentId" => $departmentId, "startDate" => $startDate, "endDate" => $endDate]);
    }
    /**
     * 根据部门id获取考勤信息
     * @return  array
    */
    public static function getAttendances (int $departmentId, string $startDate, string $endDate) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getAttendances(["departmentId" => $departmentId, "startDate" => $startDate, "endDate" => $endDate]);
    }
    /**
     * 批量获取请假信息
     * @return  array
    */
    public static function getLeaveList (array $staffIds, string $startDate, string $endDate) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getLeaveList(["staffIds" => $staffIds, "startDate" => $startDate, "endDate" => $endDate]);
    }
    /**
     * 是否可以领取光年卡
     * @return  bool
    */
    public static function hasAnniversaryCard (int $staffId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->hasAnniversaryCard(["staffId" => $staffId]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}