<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-04-25 19:38:54
 */
namespace Mainto\Bridge\Invokes\HimoEbsV2\ThirdParty\ThirdPlatformOrder;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class TMallOrder
 * @method tmallNotifyByParams(array $params) 天猫通知接口
 * @method generateCodeToMQByParams(array $params) 生成券码信息至mq
 * @method uploadCodeByParams(array $params) 上传券码至天猫
 * @method resendCodeToMQByParams(array $params) 重新生成发码信息至MQ
 * @method resendCodeByParams(array $params) 重新发码至天猫
 * @method useCodeToMQByParams(array $params) 使用券码通知
 * @method consumeCodeByParams(array $params) 电子凭证核销接口
 * @method refundByParams(array $params) 通知码商维权成功|通知码商退款成功
 * @method confirmRefundByParams(array $params) 确认退款
 */
class TMallOrder {
    private static string $serviceName = "HimoEbsV2";

    private static string $className = "ThirdParty\\ThirdPlatformOrder\\TMallOrder";

    /**
     * 天猫通知接口
     * @return  string
    */
    public static function tmallNotify () {
        return RpcClass::getClass(self::$serviceName, self::$className)->tmallNotify();
    }
    /**
     * 生成券码信息至mq
     * @return  bool
    */
    public static function generateCodeToMQ (\Mainto\Bridge\Structs\HimoEbsV2\ThirdParty\ThirdPlatformOrder\TMallOrder\GenerateCodeToMQParamsContent $content) {
        return RpcClass::getClass(self::$serviceName, self::$className)->generateCodeToMQ(["content" => $content]);
    }
    /**
     * 上传券码至天猫
     * @return  array
    */
    public static function uploadCode (\Mainto\Bridge\Structs\HimoEbsV2\ThirdParty\ThirdPlatformOrder\TMallOrder\UploadCodeParamsContent $content) {
        return RpcClass::getClass(self::$serviceName, self::$className)->uploadCode(["content" => $content]);
    }
    /**
     * 重新生成发码信息至MQ
     * @return  bool
    */
    public static function resendCodeToMQ (\Mainto\Bridge\Structs\HimoEbsV2\ThirdParty\ThirdPlatformOrder\TMallOrder\ResendCodeToMQParamsContent $content) {
        return RpcClass::getClass(self::$serviceName, self::$className)->resendCodeToMQ(["content" => $content]);
    }
    /**
     * 重新发码至天猫
     * @return  array
    */
    public static function resendCode (\Mainto\Bridge\Structs\HimoEbsV2\ThirdParty\ThirdPlatformOrder\TMallOrder\ResendCodeParamsContent $content) {
        return RpcClass::getClass(self::$serviceName, self::$className)->resendCode(["content" => $content]);
    }
    /**
     * 使用券码通知
     * @return  bool
    */
    public static function useCodeToMQ (string $code, int $userId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->useCodeToMQ(["code" => $code, "userId" => $userId]);
    }
    /**
     * 电子凭证核销接口
     * @return  array
    */
    public static function consumeCode (\Mainto\Bridge\Structs\HimoEbsV2\ThirdParty\ThirdPlatformOrder\TMallOrder\ConsumeCodeParamsContent $content) {
        return RpcClass::getClass(self::$serviceName, self::$className)->consumeCode(["content" => $content]);
    }
    /**
     * 通知码商维权成功|通知码商退款成功
     * @return  bool
    */
    public static function refund (\Mainto\Bridge\Structs\HimoEbsV2\ThirdParty\ThirdPlatformOrder\TMallOrder\RefundParamsContent $content) {
        return RpcClass::getClass(self::$serviceName, self::$className)->refund(["content" => $content]);
    }
    /**
     * 确认退款
     * @return  bool
    */
    public static function confirmRefund (array $content) {
        return RpcClass::getClass(self::$serviceName, self::$className)->confirmRefund(["content" => $content]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}