<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-04-25 17:36:19
 */
namespace Mainto\Bridge\Invokes\HimoEbsV2\Tool;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Store
 * @method syncStoreEventByParams(array $params) 同步指定门店事件到指定服务或第三方
 * @method updateOvoparkStoreByParams(array $params) 修改万店掌侧接口异常导致的错误数据
 */
class Store {
    private static string $serviceName = "HimoEbsV2";

    private static string $className = "Tool\\Store";

    /**
     * 同步指定门店事件到指定服务或第三方
     * @return  array
    */
    public static function syncStoreEvent (int $storeId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->syncStoreEvent(["storeId" => $storeId]);
    }
    /**
     * 修改万店掌侧接口异常导致的错误数据
     * @return  bool
    */
    public static function updateOvoparkStore (int $storeId, int $ovoparkStoreId, int $ovoparkOrganizeId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->updateOvoparkStore(["storeId" => $storeId, "ovoparkStoreId" => $ovoparkStoreId, "ovoparkOrganizeId" => $ovoparkOrganizeId]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}