<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-04-25 17:36:19
 */
namespace Mainto\Bridge\Invokes\HimoEbsV2\Inside;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class JdSkuBind
 * @method createByParams(array $params) 增加绑定关系
 * @method updateByParams(array $params) 更新绑定关系
 * @method getPageListByParams(array $params) 京东发码商品绑定列表-分页
 * @method deleteByParams(array $params) 删除绑定关系
 * @method infoByParams(array $params) 获取京东券码绑定详情
 */
class JdSkuBind {
    private static string $serviceName = "HimoEbsV2";

    private static string $className = "Inside\\JdSkuBind";

    /**
     * 增加绑定关系
     * @return  int
    */
    public static function create (string $jdSkuId, string $jdGoodName, int $templateId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->create(["jdSkuId" => $jdSkuId, "jdGoodName" => $jdGoodName, "templateId" => $templateId]);
    }
    /**
     * 更新绑定关系
     * @return  int
    */
    public static function update (int $id, string $jdSkuId, string $jdGoodName, int $templateId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->update(["id" => $id, "jdSkuId" => $jdSkuId, "jdGoodName" => $jdGoodName, "templateId" => $templateId]);
    }
    /**
     * 京东发码商品绑定列表-分页
     * @return  array
    */
    public static function getPageList () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getPageList([]);
    }
    /**
     * 删除绑定关系
     * @return  bool
    */
    public static function delete (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->delete(["id" => $id]);
    }
    /**
     * 获取京东券码绑定详情
     * @return  array
    */
    public static function info (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->info(["id" => $id]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}