<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-04-26 11:14:55
 */
namespace Mainto\Bridge\Invokes\HimoEbsV2\Inside;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class SfExpress
 * @method createOrderByParams(array $params) 统一下单
 * @method cancelOrderByParams(array $params) 取消订单
 * @method searchOrderByParams(array $params) 下单结果查询
 * @method routeQueryByParams(array $params) 路由查询
 * @method initRandomSequenceByParams(array $params) 生成当日日随机码
 * @method deliverTmByParams(array $params) 时效查询
 * @method scheduleByParams(array $params) 调度信息查询
 * @method freightByParams(array $params) 清单运费查询
 * @method waybillIntercepterByParams(array $params) 通缉拦截接口
 */
class SfExpress {
    private static string $serviceName = "HimoEbsV2";

    private static string $className = "Inside\\SfExpress";

    /**
     * 统一下单
     * @return  mixed
    */
    public static function createOrder (array $params) {
        return RpcClass::getClass(self::$serviceName, self::$className)->createOrder(["params" => $params]);
    }
    /**
     * 取消订单
     * @return  mixed
    */
    public static function cancelOrder (string $recordNo, string $mailNumber) {
        return RpcClass::getClass(self::$serviceName, self::$className)->cancelOrder(["recordNo" => $recordNo, "mailNumber" => $mailNumber]);
    }
    /**
     * 下单结果查询
     * @return  mixed
    */
    public static function searchOrder (string $recordNo, string $mailNumber) {
        return RpcClass::getClass(self::$serviceName, self::$className)->searchOrder(["recordNo" => $recordNo, "mailNumber" => $mailNumber]);
    }
    /**
     * 路由查询
     * @return  mixed
    */
    public static function routeQuery (string $recordNo, string $mailNumber) {
        return RpcClass::getClass(self::$serviceName, self::$className)->routeQuery(["recordNo" => $recordNo, "mailNumber" => $mailNumber]);
    }
    /**
     * 生成当日日随机码
     * @return  array
    */
    public static function initRandomSequence () {
        return RpcClass::getClass(self::$serviceName, self::$className)->initRandomSequence();
    }
    /**
     * 时效查询
     * @return  array
    */
    public static function deliverTm (string $srcAddress, string $destAddress) {
        return RpcClass::getClass(self::$serviceName, self::$className)->deliverTm(["srcAddress" => $srcAddress, "destAddress" => $destAddress]);
    }
    /**
     * 调度信息查询
     * @return  array
    */
    public static function schedule () {
        return RpcClass::getClass(self::$serviceName, self::$className)->schedule([]);
    }
    /**
     * 清单运费查询
     * @return  array
    */
    public static function freight () {
        return RpcClass::getClass(self::$serviceName, self::$className)->freight([]);
    }
    /**
     * 通缉拦截接口
     * @return  bool
    */
    public static function waybillIntercepter () {
        return RpcClass::getClass(self::$serviceName, self::$className)->waybillIntercepter([]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}